<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();
$title  = $shortcode->getVal( 'title' );


if ( $title === '' ) {
	return;
}


$is_cover             = $shortcode->getVal( 'use_as_title_cover' );
$optcity_to           = $shortcode->getVal( 'opacity_to', 0.07 );
$move_to_duration     = $shortcode->getVal( 'move_to_duration', "0%" );
$move_from_duration   = $shortcode->getVal( 'move_from_duration', "-100%" );
$triggerhook_duration = $shortcode->getVal( 'triggerhook_duration', "bottom" );
$stop_on_mobile       = $shortcode->getVal( 'stop_on_mobile' );


if ( $is_cover ) {
	$widget->add_render_attribute( 'title', [
		'class'                => 'title-cover',
		'data-dsn-grid'        => 'move-section',
		'data-dsn-opacity'     => $optcity_to,
		'data-dsn-to'          => $move_to_duration,
		'data-dsn-from'        => $move_from_duration,
		'data-dsn-triggerhook' => $triggerhook_duration,
	] );

	if ( $stop_on_mobile ) {
		$widget->add_render_attribute( 'title', 'data-dsn-responsive', 'tablet' );
	}

	$is_link = false;
} else {
	$is_link = $shortcode->getOptionArray( $shortcode->getVal( 'link', array() ), 'url' );
}


$size     = $shortcode->getSize();
$html_tag = $shortcode->getHtmlTag();

$fill_text = $shortcode->getVal( 'fill_text' );

if ( $is_link && ! empty( $is_link ) ) {
	$widget->add_link_attributes( 'link', $shortcode->getVal( 'link' ) )
	       ->add_render_attribute( 'link', 'class', 'init-color' );
	if ( $fill_text ) {
		$widget->add_render_attribute( 'link', 'data-fill-text', esc_attr( $title ) );
		$fill_text = false;
	}


	$title = sprintf( '<a %1$s>%2$s</a>', $widget->get_render_attribute_string( 'link' ), $title );
}


if ( $size ) {
	$widget->add_render_attribute( 'title', 'class', $size );
}


$widget->add_render_attribute( 'title', 'class', [
	'dsn-heading-title d-inline-block p-relative',
	$shortcode->getVal( 'dsn_title_animate', '' ),
	$shortcode->getVal( 'title_color' ),
	$shortcode->getVal( 'use_as_stroke' ),
	$shortcode->getVal( 'dsn_line_text' ),
	$shortcode->getVal( 'animate_number' ),
] );

if ( $fill_text ) {
	$widget->add_render_attribute( 'title', 'data-fill-text', esc_attr( $title ) );
}


printf( '<%1$s %2$s>%3$s</%1$s>', $html_tag, $widget->get_render_attribute_string( 'title' ), $title );
