<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();

$size            = $shortcode->getSize( 'sm-title-block' );
$html_tag        = $shortcode->getHtmlTag();
$line_text       = $shortcode->getLinetext();
$dsn_line_text_2 = $shortcode->getLinetext( '', 'dsn_line_text_2' );

$items = $shortcode->getVal( 'items', array() );


if ( ! count( $items ) ) {
	return;
}


$bg_ver_btn = $shortcode->getVal( 'bg_ver_btn', '' );
$bg_btn     = $shortcode->getVal( 'bg_btn', 'background-section' );

$widget->add_render_attribute( 'box-item', 'class', [ 'box-item grid-item p-30', $bg_ver_btn, $bg_btn ] );


foreach ( $items as $index => $item ):

	$item['use_scrolling_effects'] = false;
	$shortcode->setBlock( $item );

	$ren_text = $shortcode->getItemKey( 'title', $index );
	$widget->add_render_attribute( $ren_text, 'class', [ 'd-inline-block p-relative dsn-title', $line_text, $size ] );
	$text = $shortcode->getVal( 'title' );

	$link_open  = '';
	$link_close = '';


	if ( $text ) {
		$text = sprintf( '<%1$s %2$s><span class="%4$s">%3$s</span></%1$s>', $html_tag, $widget->get_render_attribute_string( $ren_text ), $text, $dsn_line_text_2 );
	}


	$is_link = $shortcode->getOptionArray( $shortcode->getVal( 'link', array() ), 'url' );


	if ( $is_link && ! empty( $is_link ) ) {
		$ren_link = $shortcode->getItemKey( 'link', $index );
		$widget->add_link_attributes( $ren_link, $shortcode->getVal( 'link' ) )
		       ->add_render_attribute( $ren_link, 'class', 'init-color w-100' );
		$link_open  = sprintf( '<a %1$s>', $widget->get_render_attribute_string( $ren_link ) );
		$link_close = '</a>';
	}

	printf( '<div %1$s>%2$s %3$s %4$s %5$s</div>',
		$widget->get_render_attribute_string( 'box-item' ),
		$link_open,
		blackdsn_shortcode_render_group( 'image', array( 'widget-base' => $shortcode ), array( 'caption' => $shortcode->getItemKey( 'caption', $index ) ) ),
		$text,
		$link_close
	);

	$shortcode->getWidgetBase()->remove_render_attribute( 'parallax' );

	?>

<?php endforeach; ?>
