<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();

$items = $shortcode->getVal( 'items', array() );


if ( ! count( $items ) ) {
	return;
}


$widget->add_render_attribute( 'resume', 'class', 'dsn-resume' );
?>

<div <?php echo $widget->get_render_attribute_string( 'resume' ) ?>>

	<?php foreach ( $items as $index => $item ):
		$shortcode->setSubBlock( $item );

		$key_title = $shortcode->getItemKey( 'title', $index );
		$title     = $shortcode->getSubVal( 'title' );
		$widget->add_render_attribute( $key_title, 'class', 'sm-title-block resume-title mb-15' );

		$key_position = $shortcode->getItemKey( 'position', $index );
		$position     = $shortcode->getSubVal( 'position' );
		$widget->add_render_attribute( $key_position, 'class', 'resume-position' );


		$key_desc    = $shortcode->getItemKey( 'description', $index );
		$description = $shortcode->getSubVal( 'description' );
		$widget->add_render_attribute( $key_desc, 'class', 'resume-description mt-10' );

		?>


        <div class="resume-item">
			<?php
			if ( $title ) {
				printf( '<h4 %1$s>%2$s</h4>', $widget->get_render_attribute_string( $key_title ), $title );
			}
			if ( $position ) {
				printf( '<h6 %1$s>%2$s</h6>', $widget->get_render_attribute_string( $key_position ), $position );
			}
			if ( $description ) {
				printf( '<div %1$s>%2$s</div>', $widget->get_render_attribute_string( $key_desc ), $description );
			}
			?>
        </div>


	<?php endforeach; ?>

</div>