<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();

$style_btn    = $shortcode->getVal( 'style_btn', 'dsn-border-style' );
$border_style = $shortcode->getVal( 'style_border_btn', 'dsn-border' );

$isIcon = ! empty( $shortcode->getVal( 'icon', array( 'library' => '' ) )['library'] );


$widget->add_render_attribute( 'link', 'class', [
	'dsn-btn',
	$border_style,
	$shortcode->getVal( 'border_color_btn', 'border-color-default' ),
	$shortcode->getVal( 'bg_ver_btn', '' ),
	$shortcode->getVal( 'bg_btn', 'background-main' ),
	$shortcode->getVal( 'full_width' ),
	$shortcode->getVal( 'popup_vid' ),
] );

if ( $link_id = $shortcode->getVal( 'button_css_id' ) ) {
	$widget->add_render_attribute( 'link', 'id', $link_id );
}


if ( $shortcode->getVal( "type_link" ) ):
	$widget->add_render_attribute( 'link', [
		'href'          => esc_url( get_the_permalink( $shortcode->getVal( 'link_post_id' ) ) ),
		'class'         => $shortcode->getVal( 'with_ajax' ),
		'data-dsn-text' => $shortcode->getVal( 'text_with_ajax' ) ? $shortcode->getVal( 'text_with_ajax' ) : get_the_title($shortcode->getVal( 'link_post_id' ) )
	] );
	$widget->add_render_attribute( 'link', 'class', $shortcode->getVal( 'with_ajax' ) );

else :
	$widget->add_link_attributes( 'link', $shortcode->getVal( 'link', array() ) );
endif;


if ( $shortcode->getVal( 'parallax' ) ) {
	$widget->add_render_attribute( 'link', [
		'data-dsn' => 'parallax',
		'class'    => [ $shortcode->getVal( 'zoom' ), $shortcode->getVal( 'move_circle' ), ],
	] );
}


$widget->add_render_attribute( 'text', 'class', ['title-btn p-relative  z-index-1' , $shortcode->getVal('button_text_color' , 'heading-color')] );

$title = sprintf( '<span %1$s>%2$s</span>', $widget->get_render_attribute_string( 'text' ),
	$shortcode->getVal( 'text' ) );

$before_icon = '';
$after_icon  = '';


if ( $isIcon ):
	if ( $shortcode->getVal( 'icon_align' ) === 'left' ) {
		$before_icon = sprintf( '<span class="dsn-icon dsn-bg-before btn-icon-left heading-color z-index-1">%s</span>',
			$shortcode->getIcon( $shortcode->getVal( 'icon' ) ) );
		$widget->add_render_attribute( 'link', 'class', 'has-icon-left' );

	} else {
		$after_icon = sprintf( '<span class="dsn-icon dsn-bg-before btn-icon-right heading-color z-index-1">%s</span>',
			$shortcode->getIcon( $shortcode->getVal( 'icon' ) ) );
		$widget->add_render_attribute( 'link', 'class', 'has-icon-right' );
	}

endif;


printf( '<a %1$s> %2$s %3$s %4$s</a>', $widget->get_render_attribute_string( 'link' ), $before_icon, $title,
	$after_icon );
