<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content', array() );


$shortcode = new blackdsnShortCode( $attr, $items_key );


$items = $shortcode->getVal( 'items', array() );

if ( ! count( $items ) || ! is_array( $items ) ) {
	return;
}

$widget = $shortcode->getWidgetBase();


$obj_brand_item = [
	'class' => [
		'brand-item p-relative grid-item box-hover-image',
		'd-flex justify-content-center align-items-center',
		$shortcode->getVal( 'bg_ver_btn', '' ),
		$shortcode->getVal( 'bg_btn', 'background-section' ),

	]
];


$widget->add_render_attribute( 'brand-item-inner', 'class', 'brand-item-inner  over-hidden p-relative ' );
$shortcode->add_parallax_attributes( 'brand-item-inner', 'content' );

foreach ( $items as $index => $item ) :
	$shortcode->setSubBlock( $item );

	$link_key = $shortcode->getItemKey( 'link', $index );
	$is_link  = $shortcode->getOptionArray( $shortcode->getSubVal( 'link' ), 'url' );

	$link = '';
	if ( $is_link && ! empty( $is_link ) ) {
		$widget->add_link_attributes( $link_key, $shortcode->getSubVal( 'link', array() ) )
		       ->add_render_attribute( $link_key, 'class', [ 'brand-link', 'init-color' ] );
		$widget->add_render_attribute( $link_key, 'data-dsn-cutter', 'char' );


		$link = sprintf( '<a %1$s></a>', $widget->get_render_attribute_string( $link_key ) );
	}

	$text_link_key = $shortcode->getItemKey( 'text_link', $index );
	$widget->add_render_attribute( $text_link_key, 'class', 'text-brand' );
	$widget->add_render_attribute( $text_link_key, 'data-dsn-cutter', 'char' );


	$image = $shortcode->getAttachImage( $shortcode->getSubVal( 'image' ), $shortcode->getVal( 'image_size', 'thumbnail' ) );


	$brand_item_key = $shortcode->getItemKey( 'brand-item', $index );
	$widget->add_render_attribute( $brand_item_key, $shortcode->get_render_swiper_slide_attribute() );
	$widget->add_render_attribute( $brand_item_key, $obj_brand_item );
	$widget->add_render_attribute( $brand_item_key, 'class', $shortcode->getSubVal( 'border_type' ) );


	printf( '<div %1$s>%4$s<div %2$s>%3$s</div></div>',
		$widget->get_render_attribute_string( $brand_item_key ),
		$widget->get_render_attribute_string( 'brand-item-inner' ),
		$image,
		$link
	);

endforeach;