<?php


class blackdsnShortCode {
	protected $attr = array();
	protected $widgetBase = null;
	protected $block = array();
	protected $subBlock = array();
	protected $isElementor = false;


	private $items = array();

	public function __construct( $attr, $items = array() ) {

		$this->attr = $attr;

		$this->widgetBase = blackdsn_get_option_array( $attr, 'widget-base', null );
		if ( $this->widgetBase instanceof blackdsnShortCode ):
			$this->block      = $this->widgetBase->getBlock();
			$this->widgetBase = $this->widgetBase->getWidgetBase();
		else:
			if ( $this->widgetBase !== null ) :
				$this->block = $this->widgetBase->get_settings_for_display();
			endif;
		endif;

		if ( is_array( $items ) ) {
			$this->items = $items;
		}


	}

	/**
	 * @param $options
	 * @param $id
	 * @param false $default
	 *
	 * @return false|mixed
	 */
	public function getOptionArray( $options, $id, $default = false ) {
		return blackdsn_get_option_array( $options, $id, $default );
	}

	public function getAcfOption( $id, $default = false, $post_id = false, $format_value = true ) {
		return blackdsn_acf_option( $id, $default, $post_id, $format_value );
	}


	public function getItemKey( $id, $index, $keys = 'items' ): string {
		return $this->getOptionArray( $this->getOptionArray( $this->items, $index, array() ), $id,
			$keys . '.' . $index . '.' . $id );
	}


	/**
	 * @return \Elementor\Widget_Base|bool|null
	 */

	public function getWidgetBase() {
		return $this->widgetBase;
	}

//    /**
//     * @param bool|\Elementor\Widget_Base|null $widgetBase
//     */
	public function setWidgetBase( $widgetBase ) {
		$this->widgetBase = $widgetBase;
	}


	public function getSize( $default = '', $id = 'font_size', $post_id = false ) {
		return $this->getVal( $id, $default, $post_id );
	}

	public function getHtmlTag( $default = 'h2', $id = 'dsn_html_tag', $post_id = false ) {
		return $this->getVal( $id, $default, $post_id );
	}


	public function getLinetext( $default = '', $id = 'dsn_line_text', $post_id = false ) {
		return $this->getVal( $id, $default, $post_id );
	}


	public function getVal( $id, $default = false, $post_id = false ) {

		if ( $this->widgetBase !== null ) {
			$output = $this->getOptionArray( $this->block, $id, $default );
		} else {
			$output = $this->getAcfOption( $id, $default, $post_id );
		}

		return $output;
	}


	public function getIcon( $icon, $attributes = [], $tag = 'i', $echo = false ) {
		if ( ! $echo ) {
			ob_start();
		}

		\Elementor\Icons_Manager::render_icon( $icon, $attributes, $tag );
		if ( ! $echo ) {
			return ob_get_clean();
		}

	}

	public function printIcon( $icon, $attributes = [], $tag = 'i' ) {
		\Elementor\Icons_Manager::render_icon( $icon, $attributes, $tag );
	}


	public function parse_text_editor( $content, $settings ) {
		/** This filter is documented in wp-includes/widgets/class-wp-widget-text.php */
		$content = apply_filters( 'widget_text', $content, $settings );

		$content = shortcode_unautop( $content );
		$content = do_shortcode( $content );
		$content = wptexturize( $content );

		if ( $GLOBALS['wp_embed'] instanceof \WP_Embed ) {
			$content = $GLOBALS['wp_embed']->autoembed( $content );
		}

		return $content;
	}

	/**
	 * @return false|mixed|string
	 */
	public function getCaption( $settings = null ) {


		if ( $settings === null && ! is_array( $settings ) ) {
			$settings = $this->block;
		}


		if ( ! isset( $settings['image'] ) ) {
			return '';
		}

		$caption = '';
		if ( ! class_exists( 'Elementor\Utils' ) ) {
			return $caption;
		}
		if ( ! empty( $settings['caption_source'] ) ) {
			switch ( $settings['caption_source'] ) {
				case 'attachment':
					$caption = wp_get_attachment_caption( $settings['image']['id'] );
					break;
				case 'custom':
					$caption = ! \Elementor\Utils::is_empty( $settings['caption'] ) ? $settings['caption'] : '';
			}
		}

		return $caption;
	}


	public function printVal( $id, $default = false, $post_id = false ) {
		echo $this->getVal( $id, $default, $post_id );
	}

	public function getSubVal( $id, $default = false, $post_id = false ) {
		if ( $post_id === false ) {
			$post_id = $this->getOptionArray( $this->subBlock, 'ID' );
		}

		return $this->getOptionArray( $this->subBlock, $id, $this->getAcfOption( $id, $default, $post_id ) );
	}

	public function getSubValTablet( $id, $default = false, $post_id = false ) {
		return $this->getOptionArray( $this->subBlock, $id . "_tablet", $this->getSubVal( $id, $default, $post_id ) );
	}

	public function getSubValMobile( $id, $default = false, $post_id = false ) {
		return $this->getOptionArray( $this->subBlock, $id . "_mobile", $this->getSubValTablet( $id, $default, $post_id ) );
	}


	/**
	 * @param $limit
	 * @param null $content
	 *
	 * @return string|string[]|null
	 */
	public function excerpt( $limit, $content = null ) {
		$excerpt = '';
		if ( $content != null ) {
			$excerpt = explode( ' ', $content, $limit );
		}

		if ( count( $excerpt ) >= $limit ) {
			array_pop( $excerpt );
			$excerpt = implode( " ", $excerpt );
		} else {
			$excerpt = implode( " ", $excerpt );
		}

		$excerpt = preg_replace( '`\[[^\]]*\]`', '', $excerpt );

		return $excerpt;
	}

	public function printSubVal( $id, $default = false, $post_id = false ) {
		echo $this->getSubVal( $id, $default, $post_id );

	}

	public function getValues() {
		return $this->block;
	}

	/**
	 * @param $id
	 * @param int $size
	 * @param string $unit
	 *
	 * @return string
	 */
	public function getValStyleRange( $id, $size = 0, $unit = 'px' ) {

		$val = $this->getVal( $id, array( 'size' => $size, 'unit' => $unit ) );

		return $val['size'] . ( $unit ? $val['unit'] : '' );
	}


	public function getImageId() {
		return $this->getVal( 'image', [ 'id' => false ] )['id'];
	}

	public function getValueNumberSlide( $id, $default = false ) {


		$size = $this->getVal( $id, [ 'size' => $default ] );
        if(is_array($size) && isset($size['size']))
            $size = $size['size'];


		if ( ! is_numeric( $size ) ) {
			$size = $default;
		}

		return $size;
	}

	public function getSubValueNumberSlide( $id, $default = false ) {

		return $this->getSubVal( $id, [ 'size' => $default ] )['size'];
	}

	public function getImageSrc() {
		$img = wp_get_attachment_image_src( $this->getImageId(), $this->getVal( 'size_img_popup_size', 'full' ) );
		if ( isset( $img[0] ) ) {
			return $img[0];
		}

		return false;
	}

	public function getAttachImageSrc( $img, $size = 'thumbnail' ) {
		$img = wp_get_attachment_image_src( $img, $size );


		if ( isset( $img[0] ) ) {
			return $img[0];
		}

		return false;
	}


	private function getUrlSourceImage( $img, $args = [] ) {

		$html = '';
		if ( is_array( $args ) )
			foreach ( $args as $name => $value ) {
				$html .= " $name=" . '"' . $value . '"';
			}

		if ( blackdsn_is_lazy_image() )
			return "<img src='data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==' $html data-dsn-src='" . $img['url'] . "' alt='' />";
		else
			return "<img src='" . $img['url'] . "' $html alt='' />";
	}

	public function getAttachImage( $img, $size = 'full', $args = [] ) {


		if ( isset( $img['source'] ) && $img['source'] === 'url' ) {
			return $this->getUrlSourceImage( $img, $args );
		}

		if ( ! isset( $img['id'] ) ) {
			if ( isset( $img['url'] ) )
				return $this->getUrlSourceImage( $img, $args );

		}
		$thumbnail_id = $img['id'];
		if ( blackdsn_is_lazy_image() ) {
			$args = array_merge( $args, array(
				'data-dsn-src'    => wp_get_attachment_image_url( $thumbnail_id, $size ),
				'data-dsn-srcset' => wp_get_attachment_image_srcset( $thumbnail_id, $size ),
				'sizes'           => wp_get_attachment_image_sizes( $thumbnail_id, $size ),
			) );
			$size = 'thumbnail';
		}

		return wp_get_attachment_image( $thumbnail_id, $size, false, $args );

	}

	public function getImageParallax( $img = null, $size = null ) {

		if ( $img === null ) {
			$img = $this->getVal( 'image' );
		}
		if ( $size === null ) {
			$size = $this->getVal( 'image_size' );
		}


		return $this->getAttachImage( $img, $size, [
				'class'          => $this->getVal( 'animate_image_style', '' ) . ' cover-bg-img ' . $this->getVal( 'direction_animate_image', '' ),
				'data-dsn-speed' => $this->getValueNumberSlide( 'speed_animation_image', '30' ) . '%',
			]
		);

	}


	/**
	 * @return array
	 */
	public function getBlock() {
		return $this->block;
	}

	/**
	 * @param array $block
	 */
	public function setBlock( $block ) {
		$this->block = $block;
	}

	/**
	 * @return array
	 */
	public function getSubBlock() {
		return $this->subBlock;
	}

	/**
	 * @param array $subBlock
	 */
	public function setSubBlock( $subBlock ) {
		$this->subBlock = $subBlock;
	}

	/**
	 * @return array
	 */
	public function get_items(): array {
		return $this->items;
	}

	/**
	 * @param array $items
	 */
	public function set_items( array $items ) {
		$this->items = $items;
	}


	public function getSwiperOption() {
		if ( method_exists( $this->widgetBase, 'getOptionSlider' ) ) {
			return $this->widgetBase->getOptionSlider( $this );
		}

		return array();
	}

	public function addPrefixClassLayout( $elment ) {
		if ( method_exists( $this->widgetBase, 'addPrefixClassLayout' ) ) {
			return $this->widgetBase->addPrefixClassLayout( $elment, $this );
		}

		return array();
	}


	public function addAnimateFade( $elment ) {
		if ( method_exists( $this->widgetBase, 'addAnimateFade' ) ) {
			return $this->widgetBase->addAnimateFade( $elment, $this );
		}

		return array();
	}


	public function add_parallax_attributes( $element, $id ) {

		if ( method_exists( $this->widgetBase, 'add_parallax_attributes' ) ) {
			return $this->widgetBase->add_parallax_attributes( $element, $id, $this );
		}

		return $this->widgetBase;
	}


	public function start_swiper() {

		if ( method_exists( $this->widgetBase, 'start_swiper' ) ) {
			return $this->widgetBase->start_swiper();
		}

		return $this->widgetBase;
	}

	public function end_swiper( $with_control = true ) {

		if ( method_exists( $this->widgetBase, 'end_swiper' ) ) {
			return $this->widgetBase->end_swiper( $with_control );
		}

		return $this->widgetBase;
	}


	public function get_content_paginate_render( $attr = null ) {

		if ( method_exists( $this->widgetBase, 'get_content_paginate_render' ) ) {
			return $this->widgetBase->get_content_paginate_render( $attr );
		}

		return $this->widgetBase;
	}


	public function print_content_paginate_render( $attr = null ) {
		echo $this->get_content_paginate_render( $attr );
	}

	/**
	 * @param $element
	 * @param null $post_id
	 * @param false $is_custom
	 * @param \DesignGrid\DsnDocElementor|null $shortcode
	 */
	public function add_overlay_attributes( $element, $post_id = null, $is_custom = false, $shortcode = null ) {

		if ( ! $is_custom ) {
			$ex = 'background_option_background_overlay_';
			if ( $shortcode )
				$opacity_overlay = $shortcode->getValueNumber( 'opacity_overlay', 4 );
			else
				$opacity_overlay = $this->getSubVal( $ex . 'opacity_overlay', 4, $post_id );


			$color              = $this->getSubVal( $ex . 'color', "#000", $post_id );
			$overlay_blend_mode = $this->getSubVal( $ex . 'overlay_blend_mode', "unset", $post_id );
		} else {

			$opacity_overlay    = $this->getSubValueNumberSlide( 'opacity_overlay', 4 );
			$color              = $this->getSubVal( 'color_overlay', "#000" );
			$overlay_blend_mode = $this->getSubVal( 'bland_overlay', "unset" );


		}

		if ( ! $overlay_blend_mode ) {
			$overlay_blend_mode = "unset";
		}


		$this->widgetBase->add_render_attribute( $element, [
			'data-overlay' => $opacity_overlay,
			'style'        => sprintf( '--bg-overlay:%s;--overlay-blend-mode:%s;', $color, $overlay_blend_mode ),
		] );
	}

	public function get_render_swiper_slide_attribute( $element = 'swiper-slid' ) {
		$swiper_item = $this->widgetBase->get_render_attributes( $element );
		if ( ! is_array( $swiper_item ) ) {
			$swiper_item = array();
		}

		return $swiper_item;
	}


}
