<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();


$widget->add_render_attribute( 'animate-line', [
	'class' => [
		'ah-headline dsn-heading-title d-inline-block p-relative',
		$shortcode->getSize(),
		$shortcode->getVal('animate_type' , 'rotate-1'),
		$shortcode->getLinetext()
	]
] );


$html_tag = $shortcode->getHtmlTag();


if ( $title_before = $shortcode->getVal( 'title_before', esc_html__( 'My favourite food is', 'blackdsn' ) ) ) {
	$title_before = sprintf( '<span %1$s>%2$s</span>
', $widget->get_render_attribute_string( 'title_before' ), $title_before );
}

if ( $title_after = $shortcode->getVal( 'title_after', '' ) ) {
	$title_after = sprintf( '<span %1$s>%2$s</span>', $widget->get_render_attribute_string( 'title_after' ), $title_after );
}

$items        = $shortcode->getVal( 'items', [] );
$animate_text = '';

if ( count( $items ) ):
	$animate_text .= '<span class="ah-words-wrapper">';

	foreach ( $items as $index => $item ):
        $shortcode->setSubBlock($item);
		if ( $index === 0 ) {
			$animate_text .= '<b class="is-visible">' . $shortcode->getSubVal('text') . '</b>';
		} else {
			$animate_text .= '<b>' . $shortcode->getSubVal('text') . '</b>';
		}
	endforeach;
	$animate_text .= '</span>
';
endif;


printf( '<%1$s %2$s>%3$s</%1$s>', $html_tag, $widget->get_render_attribute_string( 'animate-line' ), $title_before . $animate_text . $title_after );
