<?php
$attr      = get_query_var( 'attr' );
$items_key = get_query_var( 'content' );


$shortcode = new blackdsnShortCode( $attr );


$widget = $shortcode->getWidgetBase();

$items = $shortcode->getVal( 'items', array() );


if ( ! count( $items ) ) {
	return;
}

$list_with_number = $shortcode->getVal( 'list_with_number' );
$title_tag        = $shortcode->getHtmlTag();
$font_class_size  = $shortcode->getSize( 'sm-title-block' );

$widget->add_render_attribute( 'accordion', [
	'class' => 'dsn-accordion',
	'role'  => 'tablist',
] );
?>

<div <?php echo $widget->get_render_attribute_string( 'accordion' ) ?>>
    <div class="accordion__wrapper">
		<?php foreach ( $items as $index => $item ):
			$shortcode->setSubBlock( $item );

			$ren_title = $shortcode->getItemKey( 'title', $index );
			$ren_desc  = $shortcode->getItemKey( 'description', $index );


			$title       = $shortcode->getSubVal( 'title' );
			$description = $shortcode->getSubVal( 'description' );


			$isIcon     = ! empty( $shortcode->getSubVal( 'icon', array( 'library' => '' ) )['library'] );
			$class_icon = $isIcon ? 'accordion-icon' : '';

			$widget->add_render_attribute( $ren_title, [
				'class'    => [$font_class_size , 'tab-title heading-color'],
				'role'     => 'tab',
				'data-tab' => $index,
			] );

			$widget->add_render_attribute( $ren_desc, [

				'class'    => [ 'accordion__answer tab-description', ( $index === 0 ) ? 'active' : '', $class_icon ],
				'role'     => 'tabpanel',
				'data-tab' => $index,
			] );

			?>

            <div class="accordion__item  <?php echo $index === 0 ? 'active' : '' ?>">
                <div class="accordion__question user-no-selection <?php echo esc_attr( ( $index === 0 ) ? 'expanded' : '' ) ?> d-flex align-items-center  <?php echo esc_attr( $class_icon ) ?>">
					<?php
					if ( $isIcon && ! $list_with_number ): ?>
                        <span class="dsn-icon">
                                <?php $shortcode->printIcon( $shortcode->getSubVal( 'icon' ) ) ?>
                        </span>
					<?php elseif ( $list_with_number ) : printf( '<span class="number background-theme h6">%s</span>', $index + 1 ); endif; ?>

					<?php printf( "<%s %s>%s</%s>", $title_tag, $widget->get_render_attribute_string( $ren_title ), $title, $title_tag ) ?>

                </div>
                <div <?php echo $widget->get_render_attribute_string( $ren_desc ) ?> >
					<?php echo $shortcode->parse_text_editor( $description, $shortcode->getValues() ) ?>
                </div>
            </div>

		<?php endforeach; ?>
    </div>
</div>