<div id="dsn_template">
	<?php
	blackdsn_view( 'template/header', [ 'categories' => $categories ], false );
	?>

    <div id="dsn-templates-container">
		<?php

		foreach ( $templates as $key => $value ):

			$cat = '';
			if ( isset( $value['category'] ) && is_array( $value['category'] ) )
				foreach ( $value['category'] as $catVal ):
					$cat .= ' dsn-' . $catVal;
				endforeach;
			?>
            <div class="dsn-template-page dialog-header <?php echo esc_attr( $cat ) ?>">
                <div class="prev-image">
                    <a class="dsn-iframe-ready" href="<?php echo esc_attr( $value['iframe'] ) ?>">
                        <img src="<?php echo BLACKDSN__PLUGIN_DIR_URL . 'assets/img/template/' . $key . '.jpg' ?>" alt="<?php echo esc_attr( $value['name'] ) ?>" width="100%">
                        <div class="dsn-template-library-template-preview">
                            <i class="eicon-zoom-in-bold" aria-hidden="true"></i>
                        </div>
                    </a>
                </div>


                <div class="temp-footer">
                    <div class="temp-name"><?php echo esc_html( $value['name'] ) ?></div>
                    <div class="temp-insert" data-dsn-id="<?php echo esc_attr( $key ) ?>"
                         data-dsn-name="<?php echo esc_attr( $value['name'] ) ?>">
                        <i class="eicon-file-download" aria-hidden="true"></i>
						<?php esc_html_e( 'Insert', 'blackdsn' ); ?>
                    </div>
                </div>

            </div>

		<?php endforeach; ?>
    </div>

    <div id="dsn_temp_overlay">
        <img src="https://s3.envato.com/files/267820262/design%20grid%20small.png" alt="design_grid" width="80"
             height="80" style="border-radius: 50%">
        <h3><?php esc_html_e( "DSNGRID", "blackdsn" ); ?></h3>
        <h6><?php esc_html_e( "Loading...", "blackdsn" ); ?></h6>
    </div>

</div>
