<?php


use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnProducts extends \Elementor\Widget_Base
{

    use \Dsn\Element\Blackdsn_Widget_Base;


    /**
     * Get widget name.
     *
     * Retrieve accordion widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'dsn_products';
    }


    /**
     * Get widget title.
     *
     * Retrieve accordion widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return __('Blackdsn Products', 'blackdsn');
    }

    /**
     * Get widget icon.
     *
     * Retrieve accordion widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-products';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @return array Widget keywords.
     * @since 2.1.0
     * @access public
     *
     */
    public function get_keywords()
    {
        return array_merge($this->dsn_keywords(), ['woocommerce', 'shop', 'store', 'product', 'archive']);
    }


    /**
     * Register accordion widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {


        $this->heading();


    }


    private function heading()
    {
        $control = $this->getControl();

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Header', 'blackdsn'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $control->addSelect('tags', [
            'products' => esc_html__('Products', 'blackdsn'),
            'featured_products' => esc_html__('Featured Products', 'blackdsn'),
            'sale_products' => esc_html__('Sale Products', 'blackdsn'),
            'best_selling_products' => esc_html__('Best Selling Products', 'blackdsn'),
            'recent_products' => esc_html__('Recent Products', 'blackdsn'),
            'top_rated_products' => esc_html__('Top Rated Products', 'blackdsn'),
        ])
            ->setDefault('products')
            ->setLabel(esc_html__("WooCommerce Type", 'blackdsn'))
            ->get();

        $control->addNumber('limit', -1, null, 1)
            ->setLabel(esc_html__('Post Per Page', 'blackdsn'))
            ->setDescription(esc_html__('The number of products to display. Defaults to and -1 (display all)  when listing products, and -1 (display all) for categories.', 'blackdsn'))
            ->setDefault(-1)
            ->get();

        $control->addNumberSlider('columns', 1, 9, 1)
            ->setLabel(esc_html__("Columns", 'blackdsn'))
            ->setDefaultRange(4)
            ->setDescription(esc_html__('The number of columns to display. Defaults to 4.', 'blackdsn'))
            ->get();

        $control->addSwitcher('paginate')
            ->setLabel(esc_html__("Paginate", 'blackdsn'))
            ->setDescription(esc_html__('Toggles pagination on. Use in conjunction with limit. Defaults to false set to true to paginate .', 'blackdsn'))
            ->setReturn_value('true')
            ->setSeparatorBefore()
            ->get();

        $control->addSwitcher('on_sale')
            ->setLabel(esc_html__("On Sale", 'blackdsn'))
            ->setDescription(esc_html__('Will display your on-sale products.', 'blackdsn'))
            ->setReturn_value('true')
            ->get();


        $control->addSwitcher('best_selling')
            ->setLabel(esc_html__("Best Selling", 'blackdsn'))
            ->setDescription(esc_html__('Will display your best selling products.', 'blackdsn'))
            ->setReturn_value('true')
            ->get();


        $control->addSelect('orderby', [
            'date' => esc_html__('Date', 'blackdsn'),
            'id' => esc_html__('ID', 'blackdsn'),
            'menu_order' => esc_html__('Menu Order', 'blackdsn'),
            'popularity' => esc_html__('(popularity) The number of purchases', 'blackdsn'),
            'rand' => esc_html__('Randomly', 'blackdsn'),
            'rating' => esc_html__('Rating', 'blackdsn'),
            'title' => esc_html__('Title', 'blackdsn'),
        ])
            ->setDefault('title')
            ->setSeparatorBefore()
            ->setLabel(esc_html__("Orderby", 'blackdsn'))
            ->setDescription(esc_html__("Sorts the products displayed by the entered option. One or more options can be passed by adding both slugs with a space between them", 'blackdsn'))
            ->get();

        $control->addSelect('order', [
            'ASC' => esc_html__('ASC', 'blackdsn'),
            'DESC' => esc_html__('DESC', 'blackdsn')
        ])
            ->setDefault('ASC')
            ->setLabel(esc_html__("order", 'blackdsn'))
            ->setDescription(esc_html__("States whether the product order is ascending (ASC) or descending (DESC)", 'blackdsn'))
            ->get();

        $control->addSelect2('category', \DesignGrid\BlackdsnOption::getTermsArray(\DesignGrid\BlackdsnOption::PRODUCT_CATEGORY))
            ->setMultiple()
            ->setLabel(esc_html__('category', 'blackdsn'))
            ->setDefault([])
            ->get();

        $control->addSelect2('tag', \DesignGrid\BlackdsnOption::getTermsArray(\DesignGrid\BlackdsnOption::PRODUCT_TAG))
            ->setMultiple()
            ->setLabel(esc_html__('tag', 'blackdsn'))
            ->setDefault([])
            ->get();


        $this->end_controls_section();

    }


    /**
     * Render accordion widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        echo blackdsn_shortcode_render_group('products', array('widget-base' => $this));
    }

}
