<?php

namespace Dsn\Blackdsn\Element;


use BlackdsnControl;
use Elementor\Controls_Manager;

trait  TeamControl {

	public function __content_controller( BlackdsnControl $control ) {
		$control->addImageSize()->getGroup();
		$control->startRepeater();
		$control->addImage()->get();


		$control->addText( 'name' )
		        ->setLabel( esc_html__( 'name', 'blackdsn' ), true )
		        ->setDefault( 'Design Grid' )
		        ->get();


		$control->addText( 'position' )
		        ->setLabel( esc_html__( 'Position', 'blackdsn' ), true )
		        ->setDefault( 'Web Developer' )
		        ->get();


		$control->get_element_base()->add_control(
			'social_note',
			[
				'label'           => __( 'Social Note', 'plugin-name' ),
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => __( '<p style="margin-top: 15px;padding-top: 15px; border-top: 1px solid;font-size: 16px;font-weight: 600;">Social Icon</p>', 'blackdsn' ),
				'content_classes' => 'dsn-team-social-raw pt-10 mt-10 border-top',
			]
		);


		$control->get_element_base()->start_controls_tabs( 'social_effects' );


		for ( $x = 1; $x <= 5; $x ++ ):

			$control->get_element_base()->start_controls_tab( 'social-team-tab-' . $x,
				[
					'label' => 'S(' . $x . ')',
				]
			);
			$control->get_element_base()->add_control(
				'icon-' . $x,
				[
					'label'       => __( 'Icon', 'blackdsn' ),
					'type'        => Controls_Manager::ICONS,
					'label_block' => true,
					'default'     => [
						'value'   => 'fas fa-star',
						'library' => 'solid',
					],
				]
			);
			$control->addText( 'icon_' . $x )
			        ->setSeparator( "before" )
			        ->setLabel( esc_html__( 'Social Label (' . $x . ')', 'blackdsn' ) )
			        ->get();

			$control->addText( 'link_social_' . $x )
			        ->setLabel( esc_html__( 'link (' . $x . ')', 'blackdsn' ), true )
			        ->get();

			$control->get_element_base()->end_controls_tab();

		endfor;

		$control->get_element_base()->end_controls_tabs();
		$control->end_popover();


		$control->endRepeater( 'items' )
		        ->setLabel( "Items" )
		        ->setTitle_field( 'name' )
		        ->get();

	}

	public function __style_controller( BlackdsnControl $control ) {

		$control->addSelect( 'bg_ver_btn', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background Service', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_btn', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Service', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-transparent' )
		        ->get();


	}

	public function __style_content_controller( BlackdsnControl $control ) {
		$args = array(
			'text-name'     => esc_html__( 'Name', 'blackdsn' ),
			'text-position' => esc_html__( 'Position', 'blackdsn' )
		);

		foreach ( $args as $id => $value ):

			$this->start_controls_section(
				'style_content_service_' . $id,
				[
					'label' => $value,
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);


			$control->addColor( 'color_content_' . $id )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addTypography( 'item_typo_content_' . $id, '.' . $id )
			        ->getGroup();

			$control->addTextShadow( 'text_content_shadow_' . $id, '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;
	}

}