<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class GridaSwiperTeam extends \Dsn\Element\GridaSlider {

	use \Dsn\Element\Arctit_Widget_Base;
	use \Dsn\Element\TeamControl;


	protected $parallax = array();
	protected  $style_item = '.team-item-inner';

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_team_slider';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Grida Team Swiper', 'grida' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-posts-group';


	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'team', 'client' ] );
	}


	protected function _register_controls() {
		$this->parallax = array(
			'content' => esc_html__( "content", 'grida' ),
//			'image' => esc_html__( "Image", 'grida' ),
//			'social' => esc_html__( "Social", 'grida' ),
		);
		parent::_register_controls(); // TODO: Change the autogenerated stub

		$this->styleTab();
		$this->__style_content_controller( $this->getControl() );

		$this->remove_control( 'bg_color_item' );
		$this->remove_control( 'bg_ver_item' );
		$this->remove_control( 'bg_item' );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {

		$this->__content_controller( $this->getControl() );


	}

	private function styleTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'grida' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->__style_controller( $control );



		$this->end_controls_section();


	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$items_key = $this->getKeys( 'items', [ 'name' => 'none', 'position' => 'none' ] );

		$this->add_render_swiper_item( 'team-item' );
		$this->add_render_attribute( 'dsn-team', 'class', 'dsn-team' );

		echo '<div ' . $this->get_render_attribute_string( 'dsn-team' ) . '>';
		$this->start_swiper( true );
		echo grida_shortcode_render_group( 'team', array( 'widget-base' => $this ), $items_key );
		$this->end_swiper();
		echo '</div>';


	}


}
