<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class  BlackdsnGridTeam extends \Dsn\Element\BlackdsnLayout {

	use \Dsn\Element\Blackdsn_Widget_Base;
	use \Dsn\Blackdsn\Element\TeamControl;

	protected $style_item = '.team-item-inner';

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_team';

	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Team', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-posts-group';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'team', 'client' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Team Content', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$this->getLayout();
		$this->__content_controller( $control );

		$this->end_controls_section();

		$this->styleTab();
		$this->__style_content_controller( $control );

	}


	private function styleTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->getGridSpace();

		$control->addSlider( 'height', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height', 'elementor' ) )
		        ->setSelectors( '.team-item-inner .box-img', 'height: {{SIZE}}{{UNIT}};max-height: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$this->__style_controller( $control );
		$control->addPaddingGroup( 'item_padding', $this->style_item )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius', $this->style_item )
		        ->getResponsive();

		$control->addBorder( 'item_border_style', $this->style_item )->getGroup();
		$control->addBoxShadow( 'item_box_shadow', $this->style_item )->getGroup();


		$this->end_controls_section();


	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$control   = new blackdsnShortCode( array( 'widget-base' => $this ) );
		$items_key = $this->getKeys( 'items', [ 'name' => 'none', 'position' => 'none' ] );
		$this->addPrefixClassLayout( 'dsn-team', $control );
		$this->addAnimateFade( 'team-item', $control );
		$this->add_render_attribute( 'dsn-team', 'class', 'dsn-team' );

		echo '<div ' . $this->get_render_attribute_string( 'dsn-team' ) . '>';

		echo blackdsn_shortcode_render_group( 'team', array( 'widget-base' => $this ), $items_key );
		echo '</div>';

	}


}
