<?php

use Dsn\Element\BlackdsnSlider;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnMediaSlider extends BlackdsnSlider {


	protected $parallax = null;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_media_slider';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Media Slider Swiper', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-media-carousel';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'media slider' ] );
	}


	/**
	 * Register accordion widget controls Content.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {

		$this->parallax = array(
			'parallax_image' => esc_html__( 'Image', 'blackdsn' ),
			'parallax_video' => esc_html__( 'Button Video', 'blackdsn' ),
		);

		$control = $this->getControl();


		$control->startRepeater();

		$control->addChoose( 'type_slide' )
		        ->setLabel( esc_html__( 'Type', 'blackdsn' ) )
		        ->setOptionChoose( 'image', esc_html__( 'Image', 'blackdsn' ), 'eicon-image-bold' )
		        ->setOptionChoose( 'video', esc_html__( 'Video', 'blackdsn' ), 'eicon-video-camera' )
		        ->setDefault( 'image' )
		        ->get();

		$control->getGroupImage();


		$control->addLink( 'link' )
		        ->setLabelBlock()
		        ->setLabel( esc_html__( 'Link Video', 'blackdsn' ) )
		        ->setPlaceholder( esc_html__( 'Enter your video link', 'blackdsn' ) )
		        ->setConditions( 'type_slide', 'video' )
		        ->setDynamicActive( true )
		        ->setSeparator( "before" )
		        ->get();

		$this->getOverlay();


		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( 'Items', 'blackdsn' ) )
		        ->setTitle_field( 'type_slide' )
		        ->get();
		

	}

	protected function _register_controls_content_after() {
		parent::_register_controls_content_after(); // TODO: Change the autogenerated stub
		$this->update_control( 'height', [
			'selectors' => [
				'{{WRAPPER}} .img-box-parallax' => 'height: {{SIZE}}{{UNIT}};'
			]
		] );
	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$items_key = $this->getKeys( 'items', [ 'caption' => 'none' ] );
		echo blackdsn_shortcode_render_group( 'media-slider', array( 'widget-base' => $this ), $items_key );
	}


}
