<?php

namespace Dsn\Blackdsn\Element;


use BlackdsnControl;
use Elementor\Controls_Manager;

trait  ServiceControl {


	public function __content_controller( BlackdsnControl $control ) {

		$is_grid = isset( $this->isGrid ) && $this->isGrid;

		$control->addSwitcher( 'with_number' )
		        ->setLabel( esc_html__( 'With Number', 'blackdsn' ) )
		        ->setReturn_value( 'list-with-number' )
		        ->setPrefix_class()
		        ->get();


		if ( $is_grid ) {
			$control->addSwitcher( 'with_image' )
			        ->setLabel( esc_html__( 'With Bg Image', 'blackdsn' ) )
			        ->setReturn_value( 'service-with-img' )
			        ->setPrefix_class()
			        ->get();

			$control->addSlider( 'height_service', $control->getDefaultWidthHeight( 'vh' ) )
			        ->setLabel( __( 'Height', 'elementor' ) )
			        ->setSelectors( '.service-item', 'height: {{SIZE}}{{UNIT}};' )
			        ->setConditions( 'with_image', '!==', '' )
			        ->get();
		}


		$control->addChoose( 'position_icon' )
		        ->setOptionChoose( 'icon-left', __( 'Left', 'elementor' ), 'eicon-h-align-left' )
		        ->setOptionChoose( 'icon-top', __( 'Top', 'elementor' ), 'eicon-v-align-top' )
		        ->setOptionChoose( 'icon-right', __( 'Right', 'elementor' ), 'eicon-h-align-right' )
		        ->setDefault( 'icon-top' )
		        ->setLabel( esc_attr__( 'Position Icon', 'blackdsn' ) )
		        ->setPrefix_class()
		        ->get();

		$control->addChoose( 'position_align' )
		        ->setOptionChoose( 'start', __( 'Start', 'elementor' ), 'eicon-v-align-top' )
		        ->setOptionChoose( 'center', __( 'Center', 'elementor' ), 'eicon-v-align-middle' )
		        ->setOptionChoose( 'end', __( 'End', 'elementor' ), 'eicon-v-align-bottom' )
		        ->setDefault( 'start' )
		        ->setSelectors( '.service-item .service-item-inner', 'align-items:{{VALUE}}' )
		        ->setConditions( 'position_icon', '!=', 'icon-top' )
		        ->setLabel( esc_attr__( 'Align Item', 'blackdsn' ) )
		        ->getResponsive();


		$control->startRepeater();


		if ( $is_grid ) {
			$control->get_element_base()->start_controls_tabs( 'dsn_button_style' );
			$control->get_element_base()->start_controls_tab(
				'icon_tab',
				[
					'label' => __( 'Icon', 'blackdsn' ),
				]
			);
			$control->get_element_base()->add_control(
				'icon',
				[
					'label'   => __( 'Icon', 'blackdsn' ),
					'type'    => Controls_Manager::ICONS,
					'default' => [
						'value'   => 'fas fa-star',
						'library' => 'solid',
					],
				]
			);
			$control->get_element_base()->end_controls_tab();
			$control->get_element_base()->start_controls_tab(
				'image_tab',
				[
					'label' => __( 'Image', 'blackdsn' ),
				]
			);
			$control->addImage()->get();
			$control->addImageSize()->get();
			$control->get_element_base()->end_controls_tab();
			$control->get_element_base()->end_controls_tabs();


		} else {
			$control->get_element_base()->add_control(
				'icon',
				[
					'label'   => __( 'Icon', 'blackdsn' ),
					'type'    => Controls_Manager::ICONS,
					'default' => [
						'value'   => 'fas fa-star',
						'library' => 'solid',
					]
				]
			);
		}


		$control->addText( "title" )
		        ->setLabelBlock()
		        ->setLabel( esc_html__( 'Title', 'blackdsn' ), true )
		        ->setDefault( esc_html__( 'Title Service', 'blackdsn' ) )
		        ->setSeparatorBefore()
		        ->setDynamicActive( true )
		        ->get();

		$control->addTextareaEditor( "description" )
		        ->setLabel( esc_html__( 'Description', 'blackdsn' ), true )
		        ->setDefault( '<p>Te qui alii inermis vivendum, an decore libris eum. Te mel dico alia wisi, cu vitae noluisse <a href="#0" target="_blank">phaedrum</a> .</p>' )
		        ->setDynamicActive( true )
		        ->get();

		$control->addLink( 'link' )
		        ->setLabel( esc_html__( 'Link', 'blackdsn' ), true )
		        ->setDynamicActive( true )
		        ->setDefault_url()
		        ->setDefault_is_external( true )
		        ->setDefault_is_nofollow( true )
		        ->get();

		$control->addTextarea( 'text_link' )
		        ->setLabel( esc_html__( 'Text Link', 'blackdsn' ), true )
		        ->setDefault( esc_html__( "Read More", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->setConditions( 'link[url]', '!=', '' )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( "Item Service" )
		        ->setTitle_field( 'title' )
		        ->get();


	}


	public function __style_controller( BlackdsnControl $control ) {
		$control->getAlign()
		        ->setDefault( "left" )
		        ->getResponsive();

		$control->addSelect( 'bg_ver_btn', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background Service', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_btn', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Service', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-main' )
		        ->get();

		$control->addPaddingGroup( 'item_padding_service', '.service-item-inner' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius', '.service-item' )
		        ->getResponsive();

		$control->addBorder( 'item_border_style', '.service-item' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow', '.service-item' )->getGroup();
	}

	public function __style_content_controller( BlackdsnControl $control ) {
		$args = array(
			'service_title'       => esc_html__( 'Title', 'blackdsn' ),
			'service_description' => esc_html__( 'Description', 'blackdsn' )
		);

		foreach ( $args as $id => $value ):

			$this->start_controls_section(
				'style_content_service_' . $id,
				[
					'label' => $value,
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);


			$control->addColor( 'color_content_' . $id )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addTypography( 'item_typo_content_' . $id, '.' . $id )
			        ->getGroup();

			if ( $id === 'service_title' ) {
				$control->addSize()
				        ->setDefault( 'title-block' )
				        ->get();
				$control->addSelect( 'line_service_item', [
					''                                           => esc_html__( 'Default', '' ),
					'border-top pt-20'                           => esc_html__( 'Border Top', 'blackdsn' ),
					'border-bottom pb-20 mb-20'                  => esc_html__( 'Border Bottom', 'blackdsn' ),
					'border-top pt-20 border-bottom pb-20 mb-20' => esc_html__( 'Both Border Bottom', 'blackdsn' ),
					'border-section-bottom'                      => esc_html__( 'Border Bottom Line', 'blackdsn' ),
					'border-section-bottom border-top pt-20 '    => esc_html__( 'Both Border Bottom Line', 'blackdsn' ),
				] )
				        ->setDefault( '' )
				        ->setLabel( __( 'Line Text', 'blackdsn' ) )
				        ->get();
			} else {
				$control->addSpacing( 'space_' . $id, '.' . $id, 'top' )
				        ->get();
			}


			$control->addTextShadow( 'text_content_shadow_' . $id, '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;


		$this->start_controls_section(
			'style_content_service_icon',
			[
				'label' => esc_html__( "icon", 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$control->addIconColor( 'icon_color_select' )
		        ->setPrefix_class()
		        ->get();


		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Color', 'elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'condition' => [
					'icon_color_select' => ''
				],
				'selectors' => [
					'{{WRAPPER}} .dsn-icon:not(.dsn-bg-before) i'        => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsn-icon:not(.dsn-bg-before) svg'      => 'fill: {{VALUE}};',
					'{{WRAPPER}} .dsn-icon:not(.dsn-bg-before) svg path' => 'fill: {{VALUE}};',
				],

			]
		);

		$control->addSlider( 'width_icon', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Size Icon', 'elementor' ) )
		        ->setSelectors( '.dsn-service .dsn-icon:not(.dsn-bg-before):not(.dsn-bg-before)', '--dsn-icon-size: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();


		$control->addPaddingGroup( 'item_padding_icon', '.dsn-icon:not(.dsn-bg-before) i ,{{WRAPPER}} .dsn-icon:not(.dsn-bg-before)  svg' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius_icon', '.dsn-icon:not(.dsn-bg-before) i ,{{WRAPPER}} .dsn-icon:not(.dsn-bg-before) svg' )
		        ->getResponsive();

		$control->addBorder( 'item_border_style_icon', '.dsn-icon:not(.dsn-bg-before) i ,{{WRAPPER}} .dsn-icon:not(.dsn-bg-before)  svg' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow_icon', '.dsn-icon:not(.dsn-bg-before) i ,{{WRAPPER}} .dsn-icon:not(.dsn-bg-before)  svg' )->getGroup();

		$this->end_controls_section();
	}

}