<?php

use Dsn\Blackdsn\Element\ServiceControl;
use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnSlider;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnSwiper extends BlackdsnSlider {

	use Blackdsn_Widget_Base;
	use ServiceControl;


	protected $parallax = array();
	protected $style_item = '.service-item-inner';

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_service_slider';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Service Swiper', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-facebook-comments';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'service', 'feature' ] );
	}


	protected function register_controls() {
		$this->parallax = array(
			'content' => esc_html__( "content", 'blackdsn' )
		);
		parent::register_controls(); // TODO: Change the autogenerated stub
		$this->remove_control( 'item_padding' );
		$this->remove_control( 'border_radius' );
		$this->remove_control( 'border_border' );
		$this->remove_control( 'button_box_shadow_box_shadow_type' );

		$this->styleTab();
		$this->getStyleContent();

		$this->remove_control( 'bg_color_item' );
		$this->remove_control( 'bg_ver_item' );
		$this->remove_control( 'bg_item' );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {


		$control = $this->getControl();

		$this->__content_controller( $control );


	}


	private function styleTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->__style_controller( $control );

		$this->end_controls_section();


	}

	private function getStyleContent() {
		$control = $this->getControl();
		$this->__style_content_controller( $control );

	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {


		$this->add_render_attribute( 'dsn-service', 'class', [
			'dsn-service'
		] );

		$items_key = $this->getKeys( 'items', [ 'title', 'description' => 'advanced', 'text_link' ] );

		$this->add_render_swiper_item();
		echo '<div ' . $this->get_render_attribute_string( 'dsn-service' ) . '>';
		$this->start_swiper();
		echo blackdsn_shortcode_render_group( 'service', array( 'widget-base' => $this ), $items_key );
		$this->end_swiper();
		echo '</div>';

	}


}
