<?php

use Dsn\Blackdsn\Element\ServiceControl;
use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnLayout;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnGrid extends BlackdsnLayout {

	use Blackdsn_Widget_Base;
	use ServiceControl;


	private $isGrid = true;

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_service';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Service', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-facebook-comments';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'service', 'feature' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Service Content', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$this->getLayout();

		$this->__content_controller( $control );

		$this->end_controls_section();

		$this->styleTab();
		$this->getStyleContent();

	}


	private function styleTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->getGridSpace();

		$this->__style_controller( $control );

		$this->end_controls_section();


	}

	private function getStyleContent() {
		$control = $this->getControl();

		$this->__style_content_controller( $control );


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {


		$control = $this->getShortCode();

		$items_key = $this->getKeys( 'items', [ 'title', 'description' => 'advanced', 'text_link' ] );
		$this->addPrefixClassLayout( 'dsn-service', $control );
		$this->addAnimateFade( 'service-item', $control );
		$this->add_render_attribute( 'dsn-service', 'class', [
			'dsn-service',
			$control->getVal( 'style_service',
				'dsn-none-border' ) === 'dsn-line-border' ? $control->getVal( 'with_number' ) : '',
			$control->getVal( 'position_icon', '' )
		] );

		echo '<div ' . $this->get_render_attribute_string( 'dsn-service' ) . '>';
		echo blackdsn_shortcode_render_group( 'service', array( 'widget-base' => $this ), $items_key );
		echo '</div>';

	}


}