<?php

namespace Dsn\Element;


use Elementor\Controls_Manager;

trait  SliderControl {


	public function registerSlider() {
		$control = $this->getControl();

		$control->addSelect( 'layout_style', [
			'v-dark-head'                     => esc_html__( 'Full', 'blackdsn' ),
			'v-dark-head dsn-section-padding' => esc_html__( 'Padding', 'blackdsn' )

		] )
		        ->setDefault( 'v-dark-head' )
		        ->setPrefix_class()
		        ->setLabel( esc_html__( 'Layout', 'blackdsn' ) )
		        ->get();

		$control->addSelect( 'layout_style_half', [
			''           => esc_html__( 'Default', 'blackdsn' ),
			'half-right' => esc_html__( 'Right', 'blackdsn' ),
			'half-left'  => esc_html__( 'Left', 'blackdsn' )

		] )
		        ->setDefault( '' )
		        ->setPrefix_class()
		        ->setLabel( esc_html__( 'Layout Half Image', 'blackdsn' ) )
		        ->get();


		$control->addSwitcher( 'box_shadow_head' )
		        ->setLabel( esc_attr__( 'Use Shadow Head', 'blackdsn' ) )
		        ->setReturn_value( 'box-shadow-head' )
		        ->setPrefix_class()
		        ->get();


		$control->addSwitcher( 'dsn_views' )
		        ->setLabel( esc_html__( "Custom Slider", 'blackdsn' ) )
		        ->get();


		$control->addNumberSlider( 'blog_pages_show_at_most', - 1, 100, 1 )
		        ->setDefaultRange( get_option( 'posts_per_page' ) )
		        ->setLabel( esc_html__( 'blog_pages_show_at_most', 'blackdsn' ) )
		        ->setConditions( 'dsn_views', '' )
		        ->get();

		$control->addText( 'text_link' )
		        ->setLabel( esc_html__( "Text Link ", 'blackdsn' ), true )
		        ->setDefault( esc_html__( "VIEW CASE", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->setConditions( 'dsn_views', '' )
		        ->get();

	}


	public function getSliderCustom() {
		$control = $this->getControl();
		$control->startRepeater();
		$control->addImage()->get();
		$control->addImageSize()->get();
		$this->getOverlay();

		$control->addText( 'post_title' )
		        ->setLabel( esc_html__( "title", 'blackdsn' ), true )
		        ->setDynamicActive( true )
		        ->setLabelBlock()
		        ->setSeparator( "before" )
		        ->setDefault( esc_html__( "Enter Your Title", 'blackdsn' ) )
		        ->get();

		$control->addText( 'subtitle' )
		        ->setLabel( esc_html__( "Subtitle", 'blackdsn' ), true )
		        ->setDynamicActive( true )
		        ->setLabelBlock()
		        ->get();


		$control->addTextarea( 'description_header' )
		        ->setLabel( esc_html__( "Description", 'blackdsn' ), true )
		        ->setDynamicActive( true )
		        ->setDefault( "Lorem ipsum dolor sit amet, consectetur adipisicing elit. Alias maiores molestias nisi officiis perferendis possimus qui voluptates. Accusantium beatae consequuntur dolorem nam quod reiciendis, tempore!" )
		        ->setLabelBlock()
		        ->get();


		$control->addLink( 'link1' )
		        ->setLabel( esc_html__( 'URL 1', 'blackdsn' ) )
		        ->setPlaceholder( esc_html__( "www.your-site.com", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->setSeparator( "before" )
		        ->get();

		$control->addText( "text_link1" )
		        ->setLabel( esc_html__( "Text Link 1", 'blackdsn' ), true )
		        ->setDefault( esc_html__( "VIEW CASE", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->setConditions( 'link1[url]', '!=', '' )
		        ->get();

		$control->addLink( 'link2' )
		        ->setLabel( esc_html__( 'URL 2', 'blackdsn' ) )
		        ->setPlaceholder( esc_html__( "www.your-site.com", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->setSeparator( "before" )
		        ->get();

		$control->addText( "text_link2" )
		        ->setLabel( esc_html__( "Text Link 2", 'blackdsn' ), true )
		        ->setDefault( esc_html__( "VIEW CASE", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->setConditions( 'link2[url]', '!=', '' )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( "Items", 'blackdsn' ) )
		        ->setConditions( 'dsn_views', '1' )
		        ->setSeparator( "before" )
		        ->setTitle_field( 'post_title' )
		        ->get();


	}

	/**
	 * Get Control Over
	 * Use In Child Class
	 *
	 * @param string $img_bland
	 */
	protected function getOverlay( $img_bland = '.img-box-parallax img' ) {
		$control = $this->getControl();


		$control->addColor( 'color_overlay' )
		        ->setLabel( __( 'Color Overlay' ) )
		        ->setSeparator( "before" )
		        ->get();

		$control->addNumberSlider( 'opacity_overlay', 0, 10, 1 )
		        ->setLabel( __( 'Opacity Overlay' ) )
		        ->setDefaultRange( 0 )
		        ->get();


		$control->addBlendMode( 'bland_overlay', $img_bland )
		        ->get();

	}


	protected function displayContent() {

		$control = $this->getControl();

		$this->start_controls_section(
			'content_display_content_area',
			[
				'label' => esc_html__( 'Display Content Area', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$control->addSelect2( 'show_title_area', [
			'link_with_title'  => esc_html__( 'Link With Title', 'blackdsn' ),
			'show_sub_title'   => esc_html__( 'SubTitle', 'blackdsn' ),
			'show_category'    => esc_html__( 'Category', 'blackdsn' ),
			'show_description' => esc_html__( 'Description', 'blackdsn' ),
			'show_Button1'     => esc_html__( 'Button 1', 'blackdsn' ),
			'show_Button2'     => esc_html__( 'Button 2', 'blackdsn' )
		] )
		        ->setMultiple()
		        ->setLabelBlock()
		        ->setDefault( array( 'link_with_title', 'show_category' ) )
		        ->setLabel( esc_html__( 'Display Content Area', 'blackdsn' ) )
		        ->get();


		$control->addChoose( 'direction_cat' )
		        ->setLabel( esc_html__( 'Direction Category', 'blackdsn' ) )
		        ->setOptionChoose( '', __( 'Before Title', 'blackdsn' ), 'eicon-v-align-bottom' )
		        ->setOptionChoose( '1', __( 'After Title', 'blackdsn' ), 'eicon-v-align-top' )
		        ->setCondition( [ 'show_title_area' => 'show_category' ] )
		        ->setSeparator( "before" )
		        ->setDefault( '1' )
		        ->get();

		$control->addSwitcher( 'use_cat_border' )
		        ->setLabel( esc_html__( 'Use Border Category', 'blackdsn' ) )
		        ->get();

		$control->addNumberSlider( 'excerpt_length', 15, 300, 5 )
		        ->setLabel( esc_html__( 'Excerpt length', 'blackdsn' ) )
		        ->setDefaultRange( 25 )
		        ->setSeparator( "before" )
		        ->setCondition( [ 'show_title_area' => 'show_description' ] )
		        ->get();

		$this->start_controls_tabs( 'tab_button' );

		foreach ( [ 'tab_btn-1', 'tab_btn-2' ] as $index => $btn ):

			$key = $index + 1;
			$this->start_controls_tab( $btn . '_' . $key, [
				'label'     => esc_html__( "Button" ) . ' ' . $key,
				'condition' => [ 'show_title_area' => 'show_Button' . $key ],
			] );

			$control->addSwitcher( 'with_line_' . $key )
			        ->setLabel( esc_html__( 'With Line', 'blackdsn' ) )
			        ->setReturn_value( 'line-shape line-shape-before' )
			        ->get();

			$control->addSelect( 'bg_ver_button-' . $key, $control->getOptionVerBackground() )
			        ->setLabel( esc_html__( 'Version Button ', 'blackdsn' ) )
			        ->setCondition( [ 'show_title_area' => 'show_Button' . $key ] )
			        ->get();

			$control->addSelect( 'bg_button-' . $key, $control->getOptionBackground() )
			        ->setLabel( esc_html__( 'BG Button', 'blackdsn' ) )
			        ->setDefault( 'background-transparent' )
			        ->setCondition( [ 'show_title_area' => 'show_Button' . $key ] )
			        ->get();


			$this->end_controls_tab();

		endforeach;


		$this->end_controls_tabs();


		$control->addSelect( 'style_button_bg', $control->getStyleButton() )
		        ->setLabel( esc_html__( 'Background button 1', 'blackdsn' ) )
		        ->setDefault( 'btn-2' )
		        ->setSeparator( "before" )
		        ->setCondition( [ 'show_title_area' => 'show_Button' ] )
		        ->get();


		$this->end_controls_section();
	}

	protected function query() {
		$control = $this->getControl();

		/**
		 * Query
		 */
		$this->start_controls_section(
			'content_query',
			[
				'label' => esc_html__( 'Query', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$control->addNumber( 'offset', 0, null, 1 )
		        ->setDefault( 0 )
		        ->setLabel( esc_html__( 'Offset', 'blackdsn' ), true )
		        ->setDescription( esc_html__( 'offset Display posts from the 4th one', 'blackdsn' ) )
		        ->get();

		$control->addSelect( 'orderby', [
			'none'       => esc_html__( 'No order', 'blackdsn' ),
			'ID'         => esc_html__( 'post id', 'blackdsn' ),
			'author'     => esc_html__( 'author', 'blackdsn' ),
			'menu_order' => esc_html__( 'Menu Order', 'blackdsn' ),
			'title'      => esc_html__( 'title', 'blackdsn' ),
			'name'       => esc_html__( 'name', 'blackdsn' ),
			'date'       => esc_html__( 'date', 'blackdsn' ),
			'modified'   => esc_html__( 'last modified date', 'blackdsn' ),
			'rand'       => esc_html__( 'Random order', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( 'Order By', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Sort retrieved posts.', 'blackdsn' ) )
		        ->setDefault( "date" )
		        ->get();

		$control->addSelect( 'order', [
			'DESC' => esc_html__( 'descending', 'blackdsn' ),
			'ASC'  => esc_html__( 'ascending', 'blackdsn' )
		] )
		        ->setLabel( esc_html__( 'Order', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Designates the ascending or descending order of the ‘orderby‘ parameter', 'blackdsn' ) )
		        ->setDefault( "DESC" )
		        ->get();

	}

	protected function _content_pagination_Navigation() {
		$control = $this->getControl();

		$this->start_controls_section(
			'paginate_swiper_section',
			[
				'label' => esc_html__( 'Pagination & Navigation', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$control->addSwitcher( 'show_navigation' )
		        ->setLabel( esc_html__( "Pagination Bullet", 'blackdsn' ) )
		        ->get();

		$control->addSwitcher( 'show_nav_slider' )
		        ->setLabel( esc_html__( "Navigation slider", 'blackdsn' ) )
		        ->setReturn_value( "active-nav-slider" )
		        ->get();


		$control->addSwitcher( 'show_pagination' )
		        ->setLabel( esc_html__( 'Show Number', 'blackdsn' ) )
		        ->get();


		$control->getJustifyContent( 'justify_content', '.control-nav' )
		        ->setDefault( 'space-between' )
		        ->getResponsive();


		$this->end_controls_section();

	}


	protected function getStyleSliderOption() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_swiper_slides',
			[
				'label' => esc_html__( 'slides', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$control->getAlign()
		        ->setDefault( "left" )
		        ->getResponsive();

		$control->getJustifyContent( 'justify_content_slider_cat', '.head-meta' )
		        ->setLabel( "Alignment Category" )
		        ->setCondition( [ 'show_title_area' => 'show_category' ] )
		        ->setDefault( 'start' )
		        ->getResponsive();

		$control->getJustifyContent( 'justify_content_slider', '.dsn-slider-content' )
		        ->setDefault( 'start' )
		        ->getResponsive();

		$control->getAlignmentItem( 'alignment_item', '.dsn-slider-content' )->getResponsive();

		$control->addSwitcher( 'add_circle' )
		        ->setLabel( esc_html__( 'Show Circle', 'blackdsn' ) )
		        ->setReturn_value( 'dsn-slider-width-circle' )
		        ->setSeparatorBefore()
		        ->setPrefix_class()
		        ->get();

		$control->addSwitcher( 'use_parallax_circle' )
		        ->setLabel( esc_html__( 'Parallax With Scroll', 'blackdsn' ) )
		        ->setReturn_value( 'dsn-header-animation' )
		        ->setPrefix_class()
		        ->get();


//		$control->addColor( 'bg_color_item' )
//		        ->setLabel( esc_html__( "background Color", 'blackdsn' ) )
//		        ->setSeparator( "before" )
//		        ->setSelectors( $this->style_item, 'background-color:{{VALUE}};' )
//		        ->get();
//
//		$control->addSelect( 'bg_ver_item', $control->getOptionVerBackground() )
//		        ->setLabel( esc_html__( 'Version Background Slide', 'blackdsn' ) )
//		        ->setLabelBlock()
//		        ->setConditions( 'bg_color_item', '' )
//		        ->setPrefix_class()
//		        ->setDefault( '' )
//		        ->get();

//		$control->addSelect( 'bg_item', $control->getOptionBackground() )
//		        ->setLabel( esc_html__( 'Background Slide', 'blackdsn' ) )
//		        ->setLabelBlock()
//		        ->setDefault( 'background-main' )
//		        ->setPrefix_class()
//		        ->setConditions( 'bg_color_item', '' )
//		        ->setSeparator( "after" )
//		        ->get();


//		$this->add_responsive_control(
//			'item_padding',
//			[
//				'label'      => __( 'Padding', 'elementor' ),
//				'type'       => Controls_Manager::DIMENSIONS,
//				'size_units' => [ 'px', 'em', '%' ],
//				'selectors'  => [
//					'{{WRAPPER}} ' . $this->style_item => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
//				],
//
//				'separator' => 'before',
//			]
//		);

//		$this->add_group_control(
//			Group_Control_Border::get_type(),
//			[
//				'name'      => 'border',
//				'selector'  => '{{WRAPPER}} ' . $this->style_item,
//				'separator' => 'before',
//			]
//		);

//		$this->add_control(
//			'border_radius',
//			[
//				'label'      => __( 'Border Radius', 'elementor' ),
//				'type'       => Controls_Manager::DIMENSIONS,
//				'size_units' => [ 'px', '%' ],
//				'selectors'  => [
//					'{{WRAPPER}} ' . $this->style_item => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
//				],
//			]
//		);
//
//		$this->add_group_control(
//			\Elementor\Group_Control_Box_Shadow::get_type(),
//			[
//				'name'     => 'button_box_shadow',
//				'selector' => '{{WRAPPER}} ' . $this->style_item,
//			]
//		);


		$this->end_controls_section();
		$this->getStyleContent();
	}


	private function getStyleContent() {
		$control = $this->getControl();


		$args = array(
			'title'       => esc_html__( 'Title', 'blackdsn' ),
			'description' => esc_html__( 'Description', 'blackdsn' ),
			'metas span'  => esc_html__( 'Metas', 'blackdsn' ),
			'dsn-btn'     => esc_html__( 'SubTitle', 'blackdsn' ),
		);

		foreach ( $args as $id => $value ):

			$this->start_controls_section(
				'style_content_slides-' . $id,
				[
					'label' => $value,
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);


			$control->addColor( 'color_content-' . $id )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addTypography( 'item_typo_content-' . sanitize_title( $id ), '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;


	}

}