<?php


use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\SliderControl;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnSliderThreeJS extends Widget_Base {

	use Blackdsn_Widget_Base;
	use SliderControl;

	protected $style_item = '.bg-container , .bg-container::before ,canvas';

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_slider_project_three';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Portfolio ThreeJS', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-post-slider';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'slider', 'portfolio', 'work', 'three js' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$control = $this->getControl();
		$control->addHidden( 'effect_slider' )
		        ->setDefault( 'dsn-webgl' )
		        ->get();

		$this->registerSlider();
		$this->getSliderCustom();

		$this->end_controls_section();
		$this->styleWebGel();

		$this->displayContent();
		$this->query();
		$this->end_controls_section();
		$this->_content_pagination_Navigation();
		$this->getStyleSliderOption();
	}

	private function styleWebGel() {
		$control = $this->getControl();
		$style   = [];
		for ( $x = 1; $x <= 18; $x ++ ):
			$style[ $x . '.jpg' ] = "Style " . $x;
		endfor;

		$this->start_controls_section(
			'setting_web-gel_swiper_section',
			[
				'label' => esc_html__( 'Slides Option', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS
			]
		);


		$control->addSelect( 'direction_webgl', [
			'horizontal' => esc_html__( 'horizontal', 'blackdsn' ),
			'vertical'   => esc_html__( 'Vertical', 'blackdsn' ),
		] )
		        ->setDefault( 'horizontal' )
		        ->setLabel( esc_html__( 'Direction', 'blackdsn' ) )
		        ->setDescription( esc_html__( "Can be 'horizontal' or 'vertical' (for vertical slider).", 'blackdsn' ) )
		        ->get();


		$control->addSelect( 'transition_slider', $style )
		        ->setLabel( esc_html__( "Transition Slider", 'blackdsn' ) )
		        ->setDefault( '8.jpg' )
		        ->get();

		$control->addNumberSlider( 'intensity', - 5, 5, 1 )
		        ->setLabel( esc_html__( "Intensity", 'blackdsn' ) )
		        ->setDefaultRange( - 2 )
		        ->get();

		$control->addNumberSlider( 'speed_in', 0, 5, 1 )
		        ->setLabel( esc_html__( "Speed In", 'blackdsn' ) )
		        ->setDefaultRange( 1.2 )
		        ->get();

		$control->addNumberSlider( 'speed_out', 0, 5, 1 )
		        ->setLabel( esc_html__( "Speed Out", 'blackdsn' ) )
		        ->setDefaultRange( 1.2 )
		        ->get();

		$control->addSwitcher( 'allowTouchMove' )
		        ->setLabel( esc_html__( 'allow Touch Move', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'If false, then the only way to switch the slide is use of external API functions like slidePrev or slideNext',
			        'blackdsn' ) )
		        ->setDefault( "1" )
		        ->setSeparator( "before" )
		        ->get();

		$control->addSwitcher( 'grabCursor' )
		        ->setLabel( esc_html__( 'Grab Cursor', 'blackdsn' ) )
		        ->setDefault( "1" )
		        ->setDescription( esc_html__( 'This option may a little improve desktop usability. If true, user will see the "grab" cursor when hover on Swiper.',
			        'blackdsn' ) )
		        ->get();
		$control->addSwitcher( 'mousewheel' )
		        ->setLabel( esc_html__( 'Mousewheel', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enables navigation through slides using mouse wheel.', 'blackdsn' ) )
		        ->get();

		$this->end_controls_section();
		$this->autoplay();

	}


	private function autoplay() {
		$control = $this->getControl();

		$this->start_controls_section(
			'setting_autoplay_swiper_section',
			[
				'label' => esc_html__( 'AutoPlay Option', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);


		$control->addSwitcher( 'autoplay' )
		        ->setLabel( esc_html__( 'autoplay', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Object with autoplay parameters or boolean true to enable with default settings',
			        'blackdsn' ) )
		        ->get();

		$control->addNumber( 'delay', 0, '', 1000 )
		        ->setLabel( esc_html__( 'delay', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Distance between slides in px.', 'blackdsn' ) )
		        ->setDefault( 2000 )
		        ->setConditions( 'autoplay', '1' )
		        ->get();

		$control->addSwitcher( 'disableOnInteraction' )
		        ->setLabel( esc_html__( 'Disable On Interaction', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Set to false and autoplay will not be disabled after user interactions (swipes), it will be restarted every time after interaction',
			        'blackdsn' ) )
		        ->setDefault( '1' )
		        ->setConditions( 'autoplay', '1' )
		        ->get();

		$control->addSwitcher( 'reverseDirection' )
		        ->setLabel( esc_html__( 'Reverse Direction', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enables autoplay in reverse direction', 'blackdsn' ) )
		        ->setConditions( 'autoplay', '1' )
		        ->get();

		$control->addSwitcher( 'stopOnLastSlide' )
		        ->setLabel( esc_html__( 'Stop On Last Slide', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)',
			        'blackdsn' ) )
		        ->setConditions( 'autoplay', '1' )
		        ->get();


		$control->addSwitcher( 'waitForTransition' )
		        ->setLabel( esc_html__( 'Wait For Transition', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'When enabled autoplay will wait for wrapper transition to continue. Can be disabled in case of using Virtual Translate when your slider may not have transition',
			        'blackdsn' ) )
		        ->setDefault( '1' )
		        ->setConditions( 'autoplay', '1' )
		        ->get();


		$this->end_controls_section();

	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$items_key = $this->getKeys( 'items', [
			'post_title' => 'none',
			'subtitle'   => 'none',
			'text_link1' => 'none',
			'text_link2' => 'none',
			'description_header',
		] );

		$this->add_inline_editing_attributes( 'prev_text', 'none' );
		$this->add_inline_editing_attributes( 'next_text', 'none' );

		blackdsn_render_widget_motion_effect( $this, 'main-slider' );

		echo blackdsn_shortcode_render_group( 'slider-project', array( 'widget-base' => $this ), $items_key );

	}


	public function get_style_depends(): array {
		return $this->getDepends();
	}

	public function get_script_depends(): array {
		return array_merge( $this->getDepends(), [ blackdsnFrontEnd::THREE_JS ] );
	}

	private function getDepends(): array {
		return [ blackdsnFrontEnd::SWIPER ];
	}


}
