<?php

use Dsn\Element\BlackdsnSlider;
use Dsn\Element\SliderControl;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnSliderProject extends BlackdsnSlider {

	use SliderControl;

	protected $parallax = null;

	const DISTORTION_SLIDER = 'dsn-webgl';
	protected $effect_slider = 'effect_slider';


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_slider_project';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Slider Portfolio', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-post-slider';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'slider', 'portfolio', 'work' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {


		$this->parallax = array(
			'parallax_image' => esc_html__( "Image", 'blackdsn' ),
		);


		$this->registerSlider();
		$this->getSliderCustom();


	}


	/**
	 * Display Are & Query
	 */
	protected function _register_controls_content_after() {


		$this->end_controls_section();
		$this->displayContent();
		$this->query();


	}


	protected function getStyleOption() {
		$this->getStyleSliderOption();
	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$items_key = $this->getKeys( 'items', [
			'post_title' => 'none',
			'subtitle'   => 'none',
			'text_link1' => 'none',
			'text_link2' => 'none',
			'description_header',
		] );

		$this->add_inline_editing_attributes( 'prev_text', 'none' );
		$this->add_inline_editing_attributes( 'next_text', 'none' );
		blackdsn_render_widget_motion_effect( $this , 'main-slider' );

		echo blackdsn_shortcode_render_group( 'slider-project', array( 'widget-base' => $this ), $items_key );

	}


	public function get_style_depends(): array {
		return $this->getDepends();
	}

	public function get_script_depends(): array {
		return $this->getDepends();
	}

	private function getDepends(): array {
		return [ blackdsnFrontEnd::SWIPER ];
	}


}
