<?php

namespace Dsn\Blackdsn\Element;


use BlackdsnControl;
use DesignGrid\BlackdsnOption;
use Elementor\Controls_Manager;

trait  PostControl {

	public function __content_controller( BlackdsnControl $control ) {
		$control->addSelect( 'style_post', [
			'cards'   => esc_html__( "Cards", 'blackdsn' ),
			'classic' => esc_html__( "classic", 'blackdsn' ),
			'list'    => esc_html__( "List", 'blackdsn' ),
			'metro'   => esc_html__( "Metro", 'blackdsn' ),

		] )
		        ->setLabel( esc_html__( "Skin", 'blackdsn' ) )
		        ->setDefault( "cards" )
		        ->setPrefix_class( 'dsn-style-' )
		        ->get();

		$control->addSelect( 'style_metro_post', [
			'dsn-metro-1' => esc_html__( 'Metro 1', 'blackdsn' ),
			'dsn-metro-2' => esc_html__( 'Metro 2', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( "Style Metro", 'blackdsn' ) )
		        ->setDefault( 'dsn-metro-1' )
		        ->setConditions( 'style_post', 'metro' )
		        ->setPrefix_class( 'dsn-background-inherit ' )
		        ->get();

		$control->addSelect( 'style_cards_post', [
			'box-image-normal'                 => esc_html__( "Normal", 'blackdsn' ),
			'box-image-blackdsn'               => esc_html__( "Blackdsn Card", 'blackdsn' ),
			'box-image-normal box-image-hover' => esc_html__( "Box Image Hover", 'blackdsn' ),
			'box-content-hover'                => esc_html__( "Box Content Hover", 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( "Style Cards", 'blackdsn' ) )
		        ->setDefault( 'box-image-normal' )
		        ->setConditions( 'style_post', 'cards' )
		        ->get();

		$control->addSelect( 'style_list_post', [
			''                => esc_html__( "Image Left", 'blackdsn' ),
			'dsn-image-right' => esc_html__( "Image Right", 'blackdsn' ),
			'dsn-image-odd'   => esc_html__( "Image Reverse", 'blackdsn' ),

		] )
		        ->setLabel( esc_html__( "Style List", 'blackdsn' ) )
		        ->setDefault( '' )
		        ->setConditions( 'style_post', 'list' )
		        ->setPrefix_class()
		        ->get();

		$control->addSelect( 'query_post', [
			'post'                  => esc_html__( 'post', 'blackdsn' ),
			blackdsn_project_slug() => esc_html__( 'blackdsn Portfolio', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( "Query", 'blackdsn' ) )
		        ->setDefault( "post" )
		        ->get();

		$control->addNumber( 'post_per_page', - 1, null, 1 )
		        ->setLabel( esc_html__( 'Post Per Page', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'number of posts to show per page , (-1 or 0) (show all posts) is used.',
			        'blackdsn' ) )
		        ->setDefault( 6 )
		        ->get();

		$control->addImageSize()
		        ->getGroup();


	}

	public function __title_content_controller( BlackdsnControl $control ) {
		$control->addHtmlTag()
		        ->setSeparator( "before" )
		        ->get();

		$control->addSize()
		        ->setDefault( 'title-block' )
		        ->get();
	}

	public function __excerpt_content_controller( BlackdsnControl $control ) {

		$control->addSwitcher( 'show_excerpt' )
		        ->setSeparator( "before" )
		        ->setLabel( esc_html__( "Excerpt", 'blackdsn' ) )
		        ->get();

		$control->addNumberSlider( 'excerpt_length', 15, 300, 5 )
		        ->setLabel( esc_html__( 'Excerpt length', 'blackdsn' ) )
		        ->setDefaultRange( 25 )
		        ->setCondition( [ 'show_excerpt' => '1' ] )
		        ->get();


	}


	public function __link_content_controller( BlackdsnControl $control ) {

		$control->addSwitcher( 'show_link' )
		        ->setSeparator( "before" )
		        ->setLabel( esc_html__( "Read More", 'blackdsn' ) )
		        ->setDefault( '1' )
		        ->get();

		$control->addText( 'text_link' )
		        ->setLabel( esc_html__( 'Read More Text', 'blackdsn' ) )
		        ->setDefault( esc_html__( "View Case", 'blackdsn' ) )
		        ->setConditions( 'show_link', '1' )
		        ->get();

	}

	public function __meta_content_controller( BlackdsnControl $control ) {
		$control->addSelect2( 'meta_data', [
			'date'     => esc_html__( 'Date', 'blackdsn' ),
			'category' => esc_html__( 'Category', 'blackdsn' ),
		] )->setMultiple()->setDefault( array() )->setSeparator( "before" )->setLabel( esc_html__( 'Meta Data',
			'blackdsn' ) )->get();

		$control->addText( 'separator_between' )->setLabel( esc_html__( 'Separator Between',
			'blackdsn' ) )->setDefault( '||' )->setConditions( 'meta_data', 'contains',
			'date' )->setConditions( 'meta_data', 'contains', 'category' )->setRelation( 'and' )->get();

		$control->addText( 'separator_between_cat' )->setLabel( esc_html__( 'Separator Between Category',
			'blackdsn' ) )->setDefault( ', ' )->setConditions( 'meta_data', 'contains', 'category' )->get();


	}


	public function __card_controller( BlackdsnControl $control ) {
		$this->start_controls_section(
			'style_card_section',
			[
				'label' => esc_html__( 'Card', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$control->addSelect( 'bg_ver_btn',
			$control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_btn', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-main' )
		        ->get();

		$control->addPaddingGroup( 'item_padding', '.root-posts .dsn-posts .box-content .post-content' )
		        ->setSeparator( "before" )
		        ->getResponsive();

		$control->addMarginGroup( 'item_margin', '.root-posts .dsn-posts .box-content .post-content' )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius', '.root-posts .dsn-posts .box-content .post-content' )
		        ->getResponsive();

		$control->addBorder( 'item_border_style', '.root-posts .dsn-posts .box-content .post-content' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow', '.root-posts .dsn-posts .box-content .post-content' )->getGroup();


		$this->end_controls_section();


	}

	public function __image_style_controller( BlackdsnControl $control ) {
		$this->start_controls_section(
			'style_image_section',
			[
				'label' => esc_html__( 'Image', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->Spacing( 'image_space', '.dsn-post-type-classic .box-image-bg' )
		     ->setConditions( 'style_post', 'classic' )
		     ->setConditions( 'style_post', 'list' )
		     ->getResponsive();

		$control->addSwitcher( 'box_shadow_head' )
		        ->setLabel( esc_attr__( 'Use Shadow Head', 'blackdsn' ) )
		        ->setReturn_value( 'box-shadow-image' )
		        ->setPrefix_class()
		        ->get();

		$control->addSelect( 'animate_image', [
			''                    => esc_html__( 'Default', 'blackdsn' ),
			'box-image-transform' => esc_html__( 'Transform', 'blackdsn' ),
			'box-image-parallax'  => esc_html__( 'Parallax', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( 'Animate Image', 'blackdsn' ) )
		        ->setDefault( '' )
		        ->setPrefix_class()
		        ->get();

		$this->end_controls_section();
	}


	public function __style_controller( BlackdsnControl $control ) {
		$args = array(
			'post-title'          => esc_html__( 'Title', 'blackdsn' ),
			'entry-meta a'        => esc_html__( 'Meta Data', 'blackdsn' ),
			'section_description' => esc_html__( 'Description', 'blackdsn' ),
			'dsn-post-link'       => esc_html__( 'Link', 'blackdsn' ),
		);

		foreach ( $args as $id => $value ):


			$this->start_controls_section(
				'style_content_post_' . sanitize_title( $id ),
				[
					'label' => $value,
					'tab'   => Controls_Manager::TAB_STYLE,
				]
			);

			if ( $id !== 'post-title' ) {
				$this->Spacing( 'spacing_content_' . sanitize_title( $id ),
					'.' . ( $id === 'post-meta a' ? 'post-meta' : $id ), $id === 'post-meta a' ? 'bottom' : 'top' )
				     ->getResponsive();
			}

			if ( $id === 'section_description' ) {
				$control->addSwitcher( 'border_left' )
				        ->setLabel( "Border Left" )
				        ->setReturn_value( 'border-before' )
				        ->get();
			}

			$control->addColor( 'color_content_' . sanitize_title( $id ) )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addTypography( 'item_typo_content_' . sanitize_title( $id ), '.' . $id )
			        ->getGroup();

			$control->addTextShadow( 'text_content_shadow_' . sanitize_title( $id ), '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;
	}


	protected function query( BlackdsnControl $control ) {


		/**
		 * Query
		 */
		$this->start_controls_section(
			'content_query',
			[
				'label' => esc_html__( 'Query', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control->addSelect2( 'include_tax', BlackdsnOption::getTermsArray( [
			'taxonomy' => [
				'category',
				blackdsn_category_slug()
			]
		], "term_id" ) )
		        ->setMultiple()
		        ->setLabelBlock()
		        ->setDefault( [] )
		        ->setPlaceholder( esc_html__( "All", "blackdsn" ) )
		        ->setLabel( esc_html__( 'Taxonomy Query', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Show posts associated with certain taxonomy.', 'blackdsn' ) )
		        ->get();

		$control->addSelect( 'operator_tax', [
			"IN"         => "IN",
			"NOT IN"     => "NOT IN",
			"AND"        => "AND",
			"EXISTS"     => "EXISTS",
			"NOT EXISTS" => "NOT EXISTS",
		] )
		        ->setDefault( "NOT IN" )
		        ->setLabelBlock()
		        ->setLabel( esc_html__( 'Operator Tax', 'blackdsn' ), true )
		        ->get();
//
//		$control->addNumber( 'offset', 0, null, 1 )
//		        ->setDefault( 0 )
//		        ->setLabel( esc_html__( 'Offset', 'blackdsn' ), true )
//		        ->setDescription( esc_html__( 'offset Display posts from the 4th one', 'blackdsn' ) )
//		        ->get();
//
//		$control->addSelect( 'orderby', [
//			'none'       => esc_html__( 'No order', 'blackdsn' ),
//			'ID'         => esc_html__( 'post id', 'blackdsn' ),
//			'author'     => esc_html__( 'author', 'blackdsn' ),
//			'menu_order' => esc_html__( 'Menu Order', 'blackdsn' ),
//			'title'      => esc_html__( 'title', 'blackdsn' ),
//			'name'       => esc_html__( 'name', 'blackdsn' ),
//			'date'       => esc_html__( 'date', 'blackdsn' ),
//			'modified'   => esc_html__( 'last modified date', 'blackdsn' ),
//			'rand'       => esc_html__( 'Random order', 'blackdsn' ),
//		] )
//		        ->setLabel( esc_html__( 'Order By', 'blackdsn' ) )
//		        ->setDescription( esc_html__( 'Sort retrieved posts.', 'blackdsn' ) )
//		        ->setDefault( "date" )
//		        ->get();
//
//		$control->addSelect( 'order', [
//			'DESC' => esc_html__( 'descending', 'blackdsn' ),
//			'ASC'  => esc_html__( 'ascending', 'blackdsn' )
//		] )
//		        ->setLabel( esc_html__( 'Order', 'blackdsn' ) )
//		        ->setDescription( esc_html__( 'Designates the ascending or descending order of the ‘orderby‘ parameter', 'blackdsn' ) )
//		        ->setDefault( "DESC" )
//		        ->get();

	}

}
