<?php

use Dsn\Blackdsn\Element\PostControl;
use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnSlider;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnPostSwiper extends BlackdsnSlider {

	use Blackdsn_Widget_Base;
	use PostControl;


	protected $parallax = array();


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_posts_slider';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Posts Swiper', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-posts-carousel';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [
			'portfolio',
			'slider',
			'posts',
			'cpt',
			'item',
			'loop',
			'query',
			'cards'
		] );
	}


	protected function register_controls() {
		$this->parallax = array(
			'box'     => esc_html__( "Box Slide", 'blackdsn' ),
			'content' => esc_html__( "Content", 'blackdsn' ),
			'image'   => esc_html__( "Image", 'blackdsn' )
		);
		parent::register_controls(); // TODO: Change the autogenerated stub

		$this->remove_control( 'bg_color_item' );
		$this->remove_control( 'bg_ver_item' );
		$this->remove_control( 'bg_item' );

		$control = $this->getControl();

		$this->Query( $control );
		$this->__card_controller( $control );
		$this->__image_style_controller( $control );
		$this->__style_controller( $control );


	}

	private function Query( blackdsnControl $control ) {
		$this->start_controls_section(
			'content_query',
			[
				'label' => esc_html__( 'Query', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$control->addNumber( 'offset', 0, null, 1 )
		        ->setDefault( 0 )
		        ->setLabel( esc_html__( 'Offset', 'blackdsn' ), true )
		        ->setDescription( esc_html__( 'offset Display posts from the 4th one', 'blackdsn' ) )
		        ->get();

		$control->addSwitcher( 'ignore_sticky_posts' )
		        ->setLabel( esc_html__( 'Ignore Sticky Posts', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Return ALL posts within the category, but don’t show sticky posts at the top. The ‘sticky posts’ will still show in their natural position',
			        'blackdsn' ) )
		        ->setDefault( '1' )
		        ->get();

		$control->addSelect( 'orderby', [
			'none'       => esc_html__( 'No order', 'blackdsn' ),
			'ID'         => esc_html__( 'post id', 'blackdsn' ),
			'author'     => esc_html__( 'author', 'blackdsn' ),
			'menu_order' => esc_html__( 'Menu Order', 'blackdsn' ),
			'title'      => esc_html__( 'title', 'blackdsn' ),
			'name'       => esc_html__( 'name', 'blackdsn' ),
			'date'       => esc_html__( 'date', 'blackdsn' ),
			'modified'   => esc_html__( 'last modified date', 'blackdsn' ),
			'rand'       => esc_html__( 'Random order', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( 'Order By', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Sort retrieved posts.', 'blackdsn' ) )
		        ->setDefault( "date" )
		        ->get();

		$control->addSelect( 'order', [
			'DESC' => esc_html__( 'descending', 'blackdsn' ),
			'ASC'  => esc_html__( 'ascending', 'blackdsn' )
		] )
		        ->setLabel( esc_html__( 'Order', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Designates the ascending or descending order of the ‘orderby‘ parameter',
			        'blackdsn' ) )
		        ->setDefault( "DESC" )
		        ->get();

		$this->end_controls_section();


	}

	protected function _register_controls_content_after() {

		parent::_register_controls_content_after(); // TODO: Change the autogenerated stub
		$control = $this->getControl();

		$this->remove_responsive_control( 'height' );

		$control->addSlider( 'height', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height Swiper', 'elementor' ) )
		        ->setConditions( 'direction', 'horizontal' )
		        ->setSelectors( '.dsn-posts', 'height: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->addSlider( 'height_image',
			$control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( esc_html__( 'Height Image', 'blackdsn' ) )
		        ->setSelectors( '.box-image-link .box-image-bg', 'height:{{SIZE}}{{UNIT}};max-height:{{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->getAlign()
		        ->setDefault( "left" )
		        ->getResponsive();

		$control->getJustifyContent( 'justify_content_posts', '.dsn-posts:not(.box-image-blackdsn) .post-content' )
		        ->setCondition( [
			        'style_post'       => 'cards',
			        'style_cards_post' => [ 'box-image-normal', 'box-image-normal box-image-hover' ],
		        ] )
		        ->getResponsive();


	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {


		$control = $this->getControl();

		$this->__content_controller( $control );

		$this->__title_content_controller( $control );
		$this->__excerpt_content_controller( $control );
		$this->__meta_content_controller( $control );
		$this->__link_content_controller( $control );


	}

	/**
	 * @param $id
	 * @param $key
	 * @param string $value
	 *
	 * @return blackdsnControl|null
	 */
	private function Spacing( $id, $key, string $value = 'bottom' ) {
		$control = $this->getControl();

		return $control->addSlider( $id, [
			'label' => esc_html__( 'Spacing', 'blackdsn' ),
			'range' => [
				'px' => [ 'max' => 100, ],
			],
		] )->setSelectors( $key, 'margin-' . $value . ':{{SIZE}}{{UNIT}}' );

	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$shortcode     = new blackdsnShortCode( array( 'widget-base' => $this ) );
		$query_post    = $shortcode->getVal( 'query_post', "post" );
		$post_per_page = $shortcode->getVal( 'post_per_page', 6 );
		$CurrentPage   = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;


		$option_query = array(
			'paged'          => $CurrentPage,
			'posts_per_page' => $post_per_page,
			'post_type'      => $query_post,
			'offset'         => $shortcode->getVal( 'offset', 0 ),
			'orderby'        => $shortcode->getVal( 'orderby', 'date' ),
			'order'          => $shortcode->getVal( 'order', 'DESC' ),
		);

		if ( $shortcode->getVal( 'ignore_sticky_posts', '1' ) ) {
			$option_query['ignore_sticky_posts'] = 1;
		}

		$myposts = new WP_Query( $option_query );

		unset( $option_query['offset'] );


		$this->add_render_attribute( 'dsn-posts', [
			'class' => [
				'dsn-posts dsn-post-type-' . $shortcode->getVal( 'style_post', 'classic' ),
				$shortcode->getVal( 'style_cards_post', '' ),
				$shortcode->getVal( 'show_number', '' ),
			]
		] );


		$this->add_render_swiper_item();
		?>
    <div class="root-posts"
         style="--dsn-row-item:<?php echo esc_attr( $shortcode->getValueNumberSlide( 'row_layout_gap', 30 ) ) ?>px">
		<?php
		printf( '<div %s>', $this->get_render_attribute_string( 'dsn-posts' ) );

		$this->add_render_attribute( 'dsn-swiper', 'class', 'has-parallax-image' );
		$this->start_swiper();


		echo blackdsn_shortcode_render_group( 'post', array( 'widget-base' => $this ), $myposts );

		$this->end_swiper();
		echo '</div></div>';

	}


}
