<?php

use Dsn\Blackdsn\Element\PostControl;
use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnLayout;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnPostGrid extends BlackdsnLayout {

	use Blackdsn_Widget_Base;
	use PostControl;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_posts';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Posts Grid', 'blackdsn' );

	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-posts-grid';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(),
			[ 'portfolio', 'posts', 'cpt', 'item', 'loop', 'query', 'cards' ] );
	}
//
//	protected function getLayoutStyle(): array {
//		return array_merge( parent::getLayoutStyle(), [
//			'dsn-isotope dsn-metro' => esc_html__( 'Metro Grid', 'blackdsn' )
//		] );
//	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();


		$this->__content_controller( $control );

		$this->getLayout();


		$this->__title_content_controller( $control );
		$this->__excerpt_content_controller( $control );
		$this->__meta_content_controller( $control );
		$this->__link_content_controller( $control );

		$this->end_controls_section();

		$this->pagination();
		$this->filterBar();

		$this->getScroll();
		$this->styleLayoutTab();
		$this->__card_controller( $control );
		$this->__image_style_controller( $control );
		$this->__style_controller( $control );
		$this->query( $control );

	}


	private function getScroll() {
		$control = $this->getControl();
		$this->start_controls_section(
			'scroll_section',
			[
				'label' => esc_html__( 'Motion Effect', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$control->addSwitcher( 'scroll_horizontal' )
		        ->setLabel( esc_html__( 'Scroll Horizontal', 'blackdsn' ) )
		        ->setReturn_value( 'use-horizontal-scroll' )
		        ->get();


		$control->addNumberSlider( 'speed_scroll', - 100, 100, 10 )
		        ->setLabel( esc_html__( 'Speed Scroll', 'blackdsn' ) )
		        ->setDefaultDesktopRange( 0 )
		        ->setConditions( 'scroll_horizontal', '!=', '' )
		        ->get();


		$control->addNumberSlider( 'start_scroll', - 1000, 1000, 1 )
		        ->setLabel( esc_html__( 'Offset Top Scroll', 'blackdsn' ) )
		        ->setDefaultDesktopRange( 0 )
		        ->setConditions( 'scroll_horizontal', '!=', '' )
		        ->get();


		$control->addSwitcher( 'start_section_title' )
		        ->setLabel( esc_html__( 'Start Title', 'blackdsn' ) )
		        ->setSeparatorBefore()
		        ->setConditions( 'scroll_horizontal', '!=', '' )
		        ->get();

		$control->addSlider( 'width_start', $control->getDefaultWidthHeight() )
		        ->setLabel( esc_html__( 'Width', 'blackdsn' ) )
		        ->setSelectors( '.start-section',
			        'max-width:calc( {{SIZE}}{{UNIT}} - var(--dsn-col-item) );flex: 0 0 calc( {{SIZE}}{{UNIT}} - var(--dsn-col-item) );' )
		        ->setConditions( 'scroll_horizontal', '!=', '', 'and' )
		        ->setConditions( 'start_section_title', '!=', '', 'and' )
		        ->getResponsive();

		$control->addText( 'start_up_title' )
		        ->setLabel( esc_html__( 'Up Title', 'blackdsn' ) )
		        ->setDefault( 'OUR' )
		        ->setConditions( 'scroll_horizontal', '!=', '', 'and' )
		        ->setConditions( 'start_section_title', '!=', '', 'and' )
		        ->get();

		$control->addText( 'start_down_title' )
		        ->setLabel( esc_html__( 'Down Title', 'blackdsn' ) )
		        ->setDefault( 'WORK' )
		        ->setConditions( 'scroll_horizontal', '!=', '', 'and' )
		        ->setConditions( 'start_section_title', '!=', '', 'and' )
		        ->get();


		$control->addSwitcher( 'end_section_title' )
		        ->setLabel( esc_html__( 'End Title', 'blackdsn' ) )
		        ->setSeparatorBefore()
		        ->setConditions( 'scroll_horizontal', '!=', '' )
		        ->get();

		$control->addSlider( 'width_end', $control->getDefaultWidthHeight() )
		        ->setLabel( esc_html__( 'Width', 'blackdsn' ) )
		        ->setSelectors( '.end-section',
			        'max-width:calc( {{SIZE}}{{UNIT}} - var(--dsn-col-item) );flex: 0 0 calc( {{SIZE}}{{UNIT}} - var(--dsn-col-item) );' )
		        ->setConditions( 'scroll_horizontal', '!=', '', 'and' )
		        ->setConditions( 'end_section_title', '!=', '', 'and' )
		        ->getResponsive();

		$control->addText( 'end_up_title' )
		        ->setLabel( esc_html__( 'Up Title', 'blackdsn' ) )
		        ->setDefault( 'AWESOME' )
		        ->setConditions( 'scroll_horizontal', '!=', '', 'and' )
		        ->setConditions( 'end_section_title', '!=', '', 'and' )
		        ->get();

		$control->addText( 'end_down_title' )
		        ->setLabel( esc_html__( 'Down Title', 'blackdsn' ) )
		        ->setDefault( 'DESIGNS' )
		        ->setConditions( 'scroll_horizontal', '!=', '', 'and' )
		        ->setConditions( 'end_section_title', '!=', '', 'and' )
		        ->get();


		$this->end_controls_section();

	}

	private function pagination() {
		$control = $this->getControl();

		$this->start_controls_section(
			'pagination_section',
			[
				'label' => esc_html__( 'Pagination',
					'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control->addSelect( 'pagination_type',
			[
				'none' => __( 'None', 'blackdsn' ),
				'nav'  => __( 'Pagination With Number', 'blackdsn' ),
				'ajax' => __( 'Button Ajax', 'blackdsn' ),
			] )
		        ->setLabel( esc_html__( 'Pagination', 'blackdsn' ) )
		        ->setDefault( 'none' )
		        ->get();

		$control->addText( 'next_post' )
		        ->setLabel( esc_html__( 'Next Post Title', 'blackdsn' ), true )
		        ->setDefault( __( 'NEXT',
			        'blackdsn' ) )
		        ->setConditions( 'pagination_type',
			        'nav' )
		        ->get();

		$control->addText( 'prev_post' )
		        ->setLabel( esc_html__( 'Prev Post Title', 'blackdsn' ), true )
		        ->setDefault( __( 'PREV', 'blackdsn' ) )
		        ->setConditions( 'pagination_type', 'nav' )
		        ->get();


		$control->addText( 'load_more_post' )
		        ->setLabel( esc_html__( 'Load More Title', 'blackdsn' ), true )
		        ->setDefault( __( 'Load More', 'blackdsn' ) )
		        ->setConditions( 'pagination_type', 'ajax' )
		        ->get();


		$control->addText( 'no_more_post' )
		        ->setLabel( esc_html__( 'No More Title', 'blackdsn' ), true )
		        ->setDynamicActive( true )
		        ->setDefault( __( 'No More', 'blackdsn' ) )
		        ->setConditions( 'pagination_type', 'ajax' )
		        ->get();

		$control->getJustifyContent( 'pagination_justify_content', '.dsn-p-pag' )
		        ->setSeparator( "before" )
		        ->setConditions( 'pagination_type', '!==', 'none' )
		        ->getResponsive();


		$control->addSlider( 'dsn-paginate-space', [
			'label' => esc_html__( 'Spacing', 'blackdsn' ),
			'range' => [
				'px' => [ 'max' => 100, ],
			],
		] )
		        ->setSelectors( '.dsn-p-pag', '--dsn-row-item:{{SIZE}}{{UNIT}}' )
		        ->setConditions( 'pagination_type', '!==', 'none' )
		        ->getResponsive();


		$this->end_controls_section();
	}

	private function filterBar() {
		$control = $this->getControl();

		$this->start_controls_section(
			'filter_bar_section',
			[
				'label' => esc_html__( 'Filter Bar', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control->addSwitcher( 'filter_bar' )
		        ->setLabel( esc_html__( 'Filter Bar', 'blackdsn' ) )
		        ->get();

		$control->addText( 'filter_title' )
		        ->setLabel( esc_html__( 'Filter Title', 'blackdsn' ),
			        true )
		        ->setDynamicActive( true )
		        ->setDefault( __( 'Filter', 'blackdsn' ) )
		        ->setConditions( 'filter_bar',
			        '1' )
		        ->get();

		$control->addText( 'all_filter' )
		        ->setLabel( esc_html__( 'Button All Filter', 'blackdsn' ), true )
		        ->setDefault( __( 'All', 'blackdsn' ) )
		        ->setConditions( 'filter_bar', '1' )
		        ->get();

		$control->getJustifyContent( 'filter_bar_justify_content', '.dsn-filtering' )
		        ->setSeparator( "before" )
		        ->setConditions( 'filter_bar', '1' )
		        ->getResponsive();

		$this->Spacing( 'dsn-filtering-space', '.dsn-filtering' )
		     ->setConditions( 'filter_bar', '1' )
		     ->getResponsive();

		$this->end_controls_section();
	}


	private function styleLayoutTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Layout',
					'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->getGridSpace();

		$control->addSlider( 'height',
			$control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( esc_html__( 'Height',
			        'blackdsn' ) )
		        ->setSelectors( '.box-image-link .box-image-bg',
			        'height:{{SIZE}}{{UNIT}};max-height:{{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->getAlign()
		        ->setDefault( "left" )
		        ->getResponsive();

		$control->getJustifyContent( 'justify_content_posts', '.dsn-posts:not(.box-image-blackdsn) .post-content' )
		        ->setCondition( [
			        'style_post'       => 'cards',
			        'style_cards_post' => [ 'box-image-normal', 'box-image-normal box-image-hover' ],
		        ] )
		        ->getResponsive();

		$control->addPaddingGroup( 'item_padding_box', '.root-posts .dsn-posts .box-content' )
		        ->setSeparator( "before" )
		        ->getResponsive();
		$control->addBorder( 'item_border_style_box', '.root-posts .dsn-posts .box-content' )
		        ->getGroup();

		$control->addBorderRadiusGroup( 'item_border_radius_box', '.root-posts .dsn-posts .box-content' )
		        ->getResponsive();

		$this->end_controls_section();


	}


	/**
	 * @param $id
	 * @param $key
	 * @param string $value
	 *
	 * @return blackdsnControl|null
	 */
	private function Spacing( $id, $key, string $value = 'bottom' ) {
		$control = $this->getControl();

		return $control->addSlider( $id, [
			'label' => esc_html__( 'Spacing', 'blackdsn' ),
			'range' => [
				'px' => [ 'max' => 100, ],
			],
		] )->setSelectors( $key, 'margin-' . $value . ':{{SIZE}}{{UNIT}}' );

	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {


		blackdsn_render_widget_motion_effect( $this, 'dsn-posts' );

		$this->add_inline_editing_attributes( 'start_up_title' );
		$this->add_inline_editing_attributes( 'end_up_title' );
		$this->add_inline_editing_attributes( 'start_down_title' );
		$this->add_inline_editing_attributes( 'end_down_title' );

		$shortcode     = new blackdsnShortCode( array( 'widget-base' => $this ) );
		$query_post    = $shortcode->getVal( 'query_post', "post" );
		$post_per_page = $shortcode->getVal( 'post_per_page', 6 );
		$CurrentPage   = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

//		$offset   = $shortcode->getVal( 'offset', 0 );
//		$orderby   = $shortcode->getVal( 'orderby', 'date' );
//		$order   = $shortcode->getVal( 'order', 'DESC' );
		$tax_query   = array(
			'relation' => 'OR',
			array(
				'taxonomy' => $query_post === blackdsn_project_slug() ? blackdsn_category_slug() : "category",
				'field'    => 'term_id',
				'terms'    => $shortcode->getVal( 'include_tax', [] ),
				'operator' => $shortcode->getVal( 'operator_tax', "NOT IN" ),
			),
		);


		$option_query = array(
			'paged'          => $CurrentPage,
			'posts_per_page' => $post_per_page,
			'post_type'      => $query_post,
//			'offset'         => $offset,
//			'orderby'        => $orderby,
//			'order'          => $order,
			'tax_query'      => $tax_query
		);

		$myposts = new WP_Query( $option_query );


		$this->addPrefixClassLayout( 'dsn-posts', $shortcode );
		$this->addAnimateFade( 'dsn-item-content', $shortcode );
		$this->add_render_attribute( 'dsn-posts',
			[
				'class' => [
					'dsn-posts dsn-post-type-' . $shortcode->getVal( 'style_post', 'classic' ),
					$shortcode->getVal( 'scroll_horizontal' ),
					$shortcode->getVal( 'style_cards_post', '' ),
					$shortcode->getVal( 'filter_bar' ) && ! $shortcode->getVal( 'scroll_horizontal' ) ? 'use-filter' : ''
				]
			] );

		if ( $shortcode->getVal( 'scroll_horizontal' ) )
			$this->add_render_attribute( 'dsn-posts',
				[
					'data-dsn-option' => json_encode( [
						'speed' => (float) $shortcode->getValueNumberSlide( 'speed_scroll', 0 ),
						'start' => $shortcode->getValueNumberSlide( 'start_scroll', 0 )
					] )
				] );


		?>
        <div class="root-posts<?php echo esc_attr( $shortcode->getVal( 'filter_bar' ) && ! $shortcode->getVal( 'scroll_horizontal' ) ? ' has-filter' : '' ) ?>"
             style="--dsn-row-item:<?php echo esc_attr( $shortcode->getValueNumberSlide( 'row_layout_gap', 30 ) ) ?>px">
			<?php

			/**
			 * Filter
			 */
			if ( ! $shortcode->getVal( 'scroll_horizontal' ) ) {
				$this->add_inline_editing_attributes( 'filter_title', 'none' );
				$this->add_inline_editing_attributes( 'all_filter', 'none' );
				echo blackdsn_shortcode_render( 'post/content/filter', $shortcode, [
					'my-posts' => $myposts,
				] );
			}


			/**
			 * Post Content
			 */
			printf( '<div %s>%s</div>',
				$this->get_render_attribute_string( 'dsn-posts' ),
				blackdsn_shortcode_render_group( 'post', array( 'widget-base' => $this ), $myposts ) );


			/**
			 * Paginate
			 */
			echo blackdsn_shortcode_render( 'post/content/paginate', $shortcode, [
				'my-posts'     => $myposts,
				'option_query' => $option_query
			] );
			?>
        </div>

		<?php


	}


}
