<?php

use Dsn\Blackdsn\Element\NavigationControl;
use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnLayout;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class  BlackdsnArrow extends \Elementor\Widget_Base {

	use Blackdsn_Widget_Base;

//	use NavigationControl;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_arrow_nav';

	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Swiper Navigation', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-instagram-nested-gallery';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'swiper', 'navigation', 'arrow' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Brand Content', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();
		$control->addText( 'title' )
		        ->setLabel( esc_html__( "Title", 'blackdsn' ) )
		        ->get();

		$control->getJustifyContent( 'justify_content', '.dsn-nav-arrow' )
		        ->setDefault( 'space-between' )
		        ->setSeparator( "before" )
		        ->getResponsive();

		$control->addSlider( 'icon_indent' )
		        ->setLabel( __( 'Icon Spacing', 'elementor' ) )
		        ->setRangePx( 0, 100 )
		        ->setSelectors( '.dsn-nav-arrow .dsn-nav-left ', 'margin-right: {{SIZE}}{{UNIT}};' )
		        ->get();

		$control->addSlider( 'width_icon', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Size Icon', 'elementor' ) )
		        ->setSelectors( '.dsn-nav-arrow .dsn-icon:not(.icon-link)', '--dsn-icon-size: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();


		$this->add_control(
			'dsn_width_layout',
			[
				'label'        => __( 'Width Layout', 'blackdsn' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => [
					''              => __( 'Default', 'blackdsn' ),
					'dsn-container' => __( 'Wide Page', 'blackdsn' ),
					'container'     => __( 'Container Page', 'blackdsn' )
				],
				'prefix_class' => '',
			]
		);


		$control->addSwitcher( "parallax" )
		        ->setLabel( esc_html__( 'Mouse Button Parallax', 'blackdsn' ) )
		        ->setSeparator( "before" )
		        ->get();

		$control->addSwitcher( "zoom" )
		        ->setLabel( esc_html__( 'Zoom Button', 'blackdsn' ) )
		        ->setReturn_value( 'image-zoom' )
		        ->setConditions( 'parallax', '1' )
		        ->get();

		$control->addSwitcher( "move_circle" )
		        ->setLabel( esc_html__( 'Move Bg', 'blackdsn' ) )
		        ->setReturn_value( 'move-circle' )
		        ->setConditions( 'parallax', '1' )
		        ->get();


		$this->end_controls_section();

		$this->styleTab();

	}


	private function styleTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$control->addSelect( 'bg_ver_btn', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_btn', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Color', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-section' )
		        ->get();


		$control->addIconColor( 'icon_color_select' )
		        ->setPrefix_class()
		        ->setSeparatorBefore()
		        ->get();


		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Color', 'elementor' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'condition' => [
					'icon_color_select' => ''
				],
				'selectors' => [
					'{{WRAPPER}} .dsn-icon i'        => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsn-icon svg'      => 'fill: {{VALUE}};',
					'{{WRAPPER}} .dsn-icon svg path' => 'fill: {{VALUE}};',
				],

			]
		);


		$control->addPaddingGroup( 'item_padding_icon', '.dsn-nav-left  ,{{WRAPPER}} .dsn-nav-right' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius_icon', '.dsn-nav-left  ,{{WRAPPER}} .dsn-nav-right' )
		        ->getResponsive();

		$control->addSelect( 'border_color_btn', $control->getBorderColor() )
		        ->setLabel( esc_html__( 'Border Color', 'blackdsn' ) )
		        ->setDefault( 'border-color-default' )
		        ->get();
		$control->addBorder( 'item_border_style_icon', '.dsn-nav-left  ,{{WRAPPER}} .dsn-nav-right' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow_icon', '.dsn-nav-left  ,{{WRAPPER}} .dsn-nav-right' )->getGroup();


		$this->end_controls_section();


	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		echo blackdsn_shortcode_render_group( 'nav-arrow', array( 'widget-base' => $this ) );
	}


}
