<?php

use Elementor\Element_Section;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor column element.
 *
 * Elementor column handler class is responsible for initializing the column
 * element.
 *
 * @since 1.0.0
 */
class  blackdsnSection extends Element_Section {


	/**
	 * Render column output in the editor.
	 *
	 * Used to generate the live preview, using a Backbone JavaScript template.
	 *
	 * @since 2.9.0
	 * @access protected
	 */


	protected function content_template() {
		?>
        <#
        view.addRenderAttribute( 'dsnWidgetWrapSection', 'class','hdev-section-color');

        if(settings.dsn_change_color){
        view.addRenderAttribute( 'dsnWidgetWrapSection','data-dsn' ,'color');
        view.addRenderAttribute( 'dsnWidgetWrapSection','data-dsn-duration' ,settings.duration_change_color);
        view.addRenderAttribute( 'dsnWidgetWrapSection','data-dsn-triggerhook' ,settings.triggerhook_change_color);
        }

        #>
        <div {{{ view.getRenderAttributeString( 'dsnWidgetWrapSection' ) }}} ></div>
		<?php
		parent::content_template(); // TODO: Change the autogenerated stub
		?>
        <#
        let dsn_img =  settings.image || {id:false , url: ''};

        if(dsn_img.id){
        let opacity_overlay =  settings.opacity_overlay || {size:4};


        view.addRenderAttribute( 'dsnImage', {
        'class'                 : 'img-box-parallax h-100 before-z-index ' ,
        'data-dsn-triggerhook'  : settings.animate_image_triggerhook || 0,
        'data-overlay'          : opacity_overlay.size,
        'data-dsn-duration'     : settings.animate_image_duration + '%',
        'data-dsn-grid'         : 'move-up',

        });

        if(settings.color_overlay)
        view.addRenderAttribute( 'dsnImage' , 'style' ,'--bg-overlay:'+settings.color_overlay);

        let p_x = settings.position_image_position_x || 50;
        let p_y = settings.position_image_position_y || 50;
        view.addRenderAttribute( 'dsnImageTag', {
        'class'                 : settings.animate_image_style + ' ' + settings.direction_animate_image,
        'src'                   : dsn_img.url,
        'alt'                   : '' ,
        'data-dsn-position'     : p_x + '% ' + p_y + '% ',
        });

        #>
        <div class="dsn-bg-section p-absolute w-100 h-100 top-0 right-0 left-0 bottom-0 over-hidden">
            <div {{{ view.getRenderAttributeString(
            'dsnImage' ) }}} >
            <img {{{ view.getRenderAttributeString('dsnImageTag' ) }}} />
        </div>
        </div>
        <#}#>
		<?php
	}


}
