<?php

namespace Dsn\Element;


use blackdsnControl;
use blackdsnShortCode;

trait  Blackdsn_Widget_Base  {


	private $control = null;


	/**
	 * @return blackdsnShortCode
	 */
	public function getShortCode(): blackdsnShortCode {
		return new blackdsnShortCode( array( 'widget-base' => $this ) );
	}

	/**
	 * @return null
	 */
	public function getControl() {
		if ( $this->control === null ) {
			$this->control = new blackdsnControl( $this );
		}

		return $this->control;
	}

	/**
	 * @param null $control
	 */
	public function setControl( $control ) {
		$this->control = $control;
	}


	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function dsn_keywords() {
		return [ 'dsn', 'blackdsn' ];
	}


	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the oEmbed widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_categories() {
		return [ 'blackdsn_cat' ];
	}


	/**
	 * @param $options
	 * @param $id
	 * @param false $default
	 *
	 * @return false|mixed
	 */
	private function getValueArray( $options, $id, $default = false ) {
		return blackdsn_get_option_array( $options, $id, $default );
	}


	/**
	 * @param $id
	 * @param array $name_element
	 *  `advanced`, `basic` or `none`
	 *
	 * @return array
	 */
	protected function getKeys( $id, array $name_element ) {
		$settings = $this->get_settings_for_display();
		$items    = $this->getValueArray( $settings, $id, array() );
		$keys     = array();

		if ( ! count( $items ) ) {
			return $keys;
		}

		foreach ( $items as $index => $item ) :
			$array_tab = array();
			foreach ( $name_element as $key => $value ) {
				if ( is_numeric( $key ) ) {
					$toolbar     = 'basic';
					$setting_key = $value;
				} else {
					$toolbar     = $value;
					$setting_key = $key;
				}

				$tab_key = $this->get_repeater_setting_key( $setting_key, $id, $index );
				$this->add_inline_editing_attributes( $tab_key, $toolbar );
				$array_tab[ $setting_key ] = $tab_key;
			}

			$keys[ $index ] = $array_tab;
		endforeach;

		return $keys;
	}


}