<?php

namespace Dsn\Element;

trait BlackdsnSwiper {


	/**
	 * @param $id
	 * @param false $default
	 *
	 * @return $this
	 */
	protected function setOptionSwiper( $id, $default = false ) {
		$this->swiper_option[ $id ] = $this->shortcode->getVal( $id, $default );

		return $this;
	}


	/**
	 * @param $id
	 * @param false $default
	 *
	 * @return $this
	 */
	protected function setOptionSwiperBoolean( $id, $default = false ) {
		$this->swiper_option[ $id ] = boolval( $this->shortcode->getVal( $id, $default ) );

		return $this;
	}


	/**
	 * @param $id
	 * @param false $default_mobile
	 * @param null $default_tablet
	 * @param null $default
	 *
	 * @return $this
	 */
	protected function setOptionSwiperResponsive( $id, $default_mobile = false, $default_tablet = null, $default = null ) {

		if ( $default_tablet === null )
			$default_tablet = $default_mobile;
		if ( $default === null )
			$default = $default_mobile;


		$this->swiper_option[ $id ] = $this->shortcode->getVal( $id . '_mobile', $default_mobile );

		$this->swiper_option['breakpoints'][0][ $id ]   = $this->shortcode->getVal( $id . '_mobile', $default_tablet );
		$this->swiper_option['breakpoints'][576][ $id ] = $this->shortcode->getVal( $id . '_mobile', $default_tablet );
		$this->swiper_option['breakpoints'][768][ $id ] = $this->shortcode->getVal( $id . '_tablet', $default_tablet );
		$this->swiper_option['breakpoints'][992][ $id ] = $this->shortcode->getVal( $id, $default );

		return $this;
	}

	/**
	 * @param $id
	 * @param false $default_mobile
	 * @param null $default_tablet
	 * @param null $default
	 *
	 * @return $this
	 */
	protected function setOptionSwiperResponsiveNumberSlider( $id, $default_mobile = false, $default_tablet = null, $default = null ) {

		if ( $default_tablet === null )
			$default_tablet = $default_mobile;
		if ( $default === null )
			$default = $default_mobile;


		$this->swiper_option[ $id ]                     = (float)$this->shortcode->getValueNumberSlide( $id . '_mobile', $default_mobile );
		$this->swiper_option['breakpoints'][0][ $id ]   = (float)$this->shortcode->getValueNumberSlide( $id . '_mobile', $default_tablet );
		$this->swiper_option['breakpoints'][576][ $id ] = (float)$this->shortcode->getValueNumberSlide( $id . '_mobile', $default_tablet );
		$this->swiper_option['breakpoints'][768][ $id ] = (float)$this->shortcode->getValueNumberSlide( $id . '_tablet', $default_tablet );
		$this->swiper_option['breakpoints'][992][ $id ] = (float)$this->shortcode->getValueNumberSlide( $id, $default );

		return $this;
	}

	/**
	 * @param $id
	 * @param false $default_mobile
	 * @param null $default_tablet
	 * @param null $default
	 *
	 * @return $this
	 */
	protected function setOptionSwiperResponsiveBoolean( $id, $default_mobile = false, $default_tablet = null, $default = null ) {
		$this->setOptionSwiperResponsive( $id, $default_mobile, $default_tablet, $default );


		$this->swiper_option[ $id ]                     = (bool) $this->swiper_option[ $id ] ;
		$this->swiper_option['breakpoints'][0][ $id ]   = (bool) $this->swiper_option['breakpoints'][0][ $id ];
		$this->swiper_option['breakpoints'][576][ $id ] = (bool) $this->swiper_option['breakpoints'][576][ $id ] ;
		$this->swiper_option['breakpoints'][768][ $id ] = (bool) $this->swiper_option['breakpoints'][768][ $id ] ;
		$this->swiper_option['breakpoints'][992][ $id ] = (bool) $this->swiper_option['breakpoints'][992][ $id ] ;

		return $this;
	}

    /**
     * @param $id
     * @param false $default
     * @param bool $isboolean
     * @return $this
     */
	protected function autoPlay( $id, $default = false, $isboolean = true ) {
		$val = $this->shortcode->getVal( $id, $default );
		if ( ! $isboolean )
			$this->swiper_option['autoplay'][ $id ] = $val;
		else
			$this->swiper_option['autoplay'][ $id ] = $val ? true : false;


		return $this;
	}


}
