<?php

namespace Dsn\Element;


use blackdsnFrontEnd;
use blackdsnShortCode;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class BlackdsnSlider extends Widget_Base {

	use Blackdsn_Widget_Base;
	use BlackdsnSwiper;

	private $swiper_option = array();
	/**
	 * @var null|blackdsnShortCode
	 */
	private $shortcode = null;

	protected $style_item = '.swiper-slide';

	protected $parallax = null;

	protected $condition_parallax = [];

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_sliders';
	}


	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'slider', 'media', 'content', 'swiper' ] );
	}


	protected function register_controls() {
		$this->start_controls_section(
			'content_swiper_section',
			[
				'label' => esc_html__( 'Slides', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->_register_controls_content_before();
		$this->_register_controls_content();
		$this->_register_controls_content_after();

		$this->end_controls_section();


		/**
		 *
		 */
		$this->_parallax_controller();
		$this->_content_pagination_Navigation();
		$this->getAdvancedOption();
		$this->getStyleOption();
	}


	protected function _register_controls_content() {
	}

	protected function _register_controls_content_before() {
	}

	/**
	 * After Content
	 */
	protected function _register_controls_content_after() {
		$control = $this->getControl();


		$control->addSwitcher( 'autoHeight' )
		        ->setLabel( esc_html__( 'auto Height', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Set to true and slider wrapper will adapt its height to the height of the currently active slide', 'blackdsn' ) )
		        ->setConditions( 'direction', 'horizontal' )
		        ->setSeparator( 'before' )
		        ->get();

		$control->addSlider( 'height', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height', 'elementor' ) )
		        ->setConditions( 'direction', 'horizontal' )
		        ->setSelectors( '.swiper-slide', 'height: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->addSlider( 'height_swiper', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height swiper', 'elementor' ) )
		        ->setConditions( 'direction', 'vertical' )
		        ->setSelectors( '.swiper-container-vertical', 'height: {{SIZE}}{{UNIT}};min-height: {{SIZE}}{{UNIT}};' )
		        ->setDefaultRange( 70, 'vh' )
		        ->getResponsive();


	}


	/**
	 * parallax Content
	 */
	protected function _parallax_controller() {

		$use_parallax = is_array( $this->parallax ) && count( $this->parallax );

		if ( ! $use_parallax ) {
			return;
		}


		$control = $this->getControl();

		$this->start_controls_section(
			'parallax_swiper_section',
			[
				'label'     => esc_html__( 'Parallax', 'blackdsn' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => $this->condition_parallax
			]
		);

		$control->addSwitcher( 'parallax' )
		        ->setLabel( esc_html__( 'parallax', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enable, if you want to use "parallaxes" elements inside of slider.', 'blackdsn' ) )
		        ->get();


		$this->start_controls_tabs( 'parallax_tab_swiper', [
			'condition' => [ 'parallax' => '1' ],
		] );

		foreach ( $this->parallax as $key => $value ):

			$this->start_controls_tab( $key, [
				'label' => $value,
			] );

			$control->addSlider( 'parallax_' . $key, [
				'default'    => [
					'unit' => '%',
					'size' => 0,
				],
				'size_units' => [ '%', 'px' ],
				'range'      => [
					'%'  => [
						'min' => - 100,
						'max' => 100,
					],
					'px' => [
						'min' => - 1000,
						'max' => 1000,
					],

				],
			] )
			        ->setLabel( esc_html__( 'parallax', 'blackdsn' ) )
			        ->setDescription( esc_html__( 'enable transform-translate parallax transition.', 'blackdsn' ) )
			        ->get();

			$control->addNumberSlider( 'scale_' . $key, 0, 2, 0.1 )
			        ->setLabel( esc_html__( 'Scale', 'blackdsn' ) )
			        ->setDefaultRange( 1 )
			        ->setDescription( esc_html__( 'scale ratio of the parallax element when it is in "inactive" (not on active slide) state', 'blackdsn' ) )
			        ->get();

			$control->addNumberSlider( 'opacity_' . $key, 0, 1, 0.1 )
			        ->setLabel( esc_html__( 'Opacity', 'blackdsn' ) )
			        ->setDefaultRange( 1 )
			        ->setDescription( esc_html__( 'opacity of the parallax element when it is in "inactive" (not on active slide) state', 'blackdsn' ) )
			        ->get();


			$control->addNumberSlider( 'duration_' . $key, 0, 10000, 100 )
			        ->setLabel( esc_html__( 'Duration', 'blackdsn' ) )
			        ->setDescription( esc_html__( 'custom transition duration for parallax elements', 'blackdsn' ) )
			        ->get();


			$this->end_controls_tab();
		endforeach;


		$this->end_controls_tabs();


		$this->end_controls_section();

	}


	/**
	 * Get Control Over
	 * Use In Child Class
	 *
	 * @param string $img_bland
	 */
	protected function getOverlay( $img_bland = '.img-box-parallax img' ) {
		$control = $this->getControl();


		$control->addColor( 'color_overlay' )
		        ->setLabel( __( 'Color Overlay' ) )
		        ->setSeparator( "before" )
		        ->get();

		$control->addNumberSlider( 'opacity_overlay', 0, 10, 1 )
		        ->setLabel( __( 'Opacity Overlay' ) )
		        ->setDefaultRange( 0 )
		        ->get();


		$control->addBlendMode( 'bland_overlay', $img_bland )
		        ->get();

	}


	/**
	 * @param $element
	 * @param $id
	 * @param blackdsnShortCode $shortcode
	 *
	 * @return $this
	 */
	public function add_parallax_attributes( $element, $id, blackdsnShortCode $shortcode ) {
		$this->shortcode = $shortcode;
		if ( ! $this->shortcode->getVal( 'parallax' ) ) {
			return $this;
		}

		$parallax = $this->shortcode->getVal( 'parallax_' . $id, array( 'unit' => '%', 'size' => 0 ) );
		$size     = $this->shortcode->getOptionArray( $parallax, 'size' );
		if ( $size ):
			$unit = $this->shortcode->getOptionArray( $parallax, 'unit', '%' );
			if ( $unit !== '%' ) {
				$unit = '';
			}

			$this->add_render_attribute( $element, 'data-swiper-parallax', $size . $unit );
		endif;
		$scale = $this->shortcode->getValueNumberSlide( 'scale_' . $id, 1 );

		if ( $scale !== 1 && $scale !== '' ) {
			$this->add_render_attribute( $element, 'data-swiper-parallax-scale', $scale );
		}

		$opacity = $this->shortcode->getValueNumberSlide( 'opacity_' . $id, 1 );
		if ( $opacity < 1 && $opacity !== '' ) {
			$this->add_render_attribute( $element, 'data-swiper-parallax-opacity', $opacity );
		}

		if ( $duration_ = $this->shortcode->getValueNumberSlide( 'duration_' . $id ) ) {
			$this->add_render_attribute( $element, 'data-swiper-parallax-duration', $duration_ );
		}


		$this->add_render_attribute( $element, 'class', 'dsn-swiper-parallax-transform' );

		return $this;
	}


	/**
	 *
	 */
	protected function getStyleOption() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_swiper_section',
			[
				'label' => esc_html__( 'Layout', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$control->addNumberSlider( 'slidesPerView', 1, 9, 0.5 )
		        ->setLabel( esc_html__( 'slides PerView', 'blackdsn' ) )
		        ->setDescription( esc_html__( "Number of slides per view (slides visible at the same time on slider's container).", 'blackdsn' ) )
		        ->setDefaultDesktopRange( 1 )
		        ->setDefaultTabletRange( 1 )
		        ->setDefaultMobileRange( 1 )
		        ->getResponsive();

		$control->addSwitcher( 'centeredSlides' )
		        ->setLabel( esc_html__( 'Centered Slides', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'If true, then active slide will be centered, not always on the left side.', 'blackdsn' ) )
		        ->getResponsive();


		$control->addNumberSlider( 'slidesPerGroup', 1, 9, 1 )
		        ->setLabel( esc_html__( 'Slides to Scroll', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Set numbers of slides to define and enable group sliding. Useful to use with slidesPerView > 1', 'blackdsn' ) )
		        ->setDefaultDesktopRange( 1 )
		        ->setDefaultTabletRange( 1 )
		        ->setDefaultMobileRange( 1 )
		        ->getResponsive();

		$control->addNumberSlider( 'spaceBetween', 0, 100, 10 )
		        ->setLabel( esc_html__( 'Space Between', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Distance between slides in px.', 'blackdsn' ) )
		        ->setDefaultDesktopRange( 0 )
		        ->setDefaultTabletRange( 0 )
		        ->setDefaultMobileRange( 0 )
		        ->getResponsive();


		$this->end_controls_section();

		$this->start_controls_section(
			'style_swiper_slides',
			[
				'label' => esc_html__( 'slides', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$control->addColor( 'bg_color_item' )
		        ->setLabel( esc_html__( "background Color", 'blackdsn' ) )
		        ->setSelectors( $this->style_item, 'background-color:{{VALUE}};' )
		        ->get();

		$control->addSelect( 'bg_ver_item', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background Slide', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setConditions( 'bg_color_item', '' )
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_item', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Slide', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-transparent' )
		        ->setConditions( 'bg_color_item', '' )
		        ->setSeparator( "after" )
		        ->get();


		$this->setFilterSwiper();


		$this->add_responsive_control(
			'item_padding_swiper',
			[
				'label'      => __( 'Padding', 'elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} ' . $this->style_item => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'      => 'border',
				'selector'  => '{{WRAPPER}} ' . $this->style_item,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label'      => __( 'Border Radius', 'elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} ' . $this->style_item => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_box_shadow',
				'selector' => '{{WRAPPER}} ' . $this->style_item,
			]
		);


		$this->end_controls_section();


	}

	/**
	 *
	 */
	public function getAdvancedOption() {

		$control = $this->getControl();
		$this->start_controls_section(
			'setting_swiper_section',
			[
				'label'     => esc_html__( 'Slides', 'blackdsn' ),
				'tab'       => Controls_Manager::TAB_SETTINGS,
				'condition' => $this->condition_parallax
			]
		);


		$control->addNumberSlider( 'speed', 300, 5000, 100 )
		        ->setLabel( esc_html__( 'Speed', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Duration of transition between slides (in ms).', 'blackdsn' ) )
		        ->setDefaultDesktopRange( 1000 )
		        ->setDefaultTabletRange( 1000 )
		        ->setDefaultMobileRange( 1000 )
		        ->getResponsive();

		$control->addSelect( 'direction', [
			'horizontal' => esc_html__( 'horizontal', 'blackdsn' ),
			'vertical'   => esc_html__( 'Vertical', 'blackdsn' ),
		] )
		        ->setDefault( 'horizontal' )
		        ->setLabel( esc_html__( 'Direction', 'blackdsn' ) )
		        ->setDescription( esc_html__( "Can be 'horizontal' or 'vertical' (for vertical slider).", 'blackdsn' ) )
		        ->get();

		$control->addSelect( 'effect', [
			'slide'     => esc_html__( 'slide', 'blackdsn' ),
			'fade'      => esc_html__( 'fade', 'blackdsn' ),
			'cube'      => esc_html__( 'cube', 'blackdsn' ),
			'coverflow' => esc_html__( 'coverflow', 'blackdsn' ),
			'flip'      => esc_html__( 'flip', 'blackdsn' ),
			'cards'     => esc_html__( 'Cards', 'blackdsn' ),
		] )
		        ->setDefault( 'slide' )
		        ->setLabel( esc_html__( 'Effect', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Transition effect. Can be "slide", "fade", "cube", "coverflow" or "flip"', 'blackdsn' ) )
		        ->get();

		$control->addSwitcher( 'loop' )
		        ->setLabel( esc_html__( 'loop', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Set to true to enable continuous loop mode', 'blackdsn' ) )
		        ->get();


		$control->addSwitcher( 'allowTouchMove' )
		        ->setLabel( esc_html__( 'allow Touch Move', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'If false, then the only way to switch the slide is use of external API functions like slidePrev or slideNext', 'blackdsn' ) )
		        ->setDefault( "1" )
		        ->setSeparator( "before" )
		        ->get();

		$control->addSwitcher( 'grabCursor' )
		        ->setLabel( esc_html__( 'Grab Cursor', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'This option may a little improve desktop usability. If true, user will see the "grab" cursor when hover on Swiper.', 'blackdsn' ) )
		        ->get();

		$control->addSwitcher( 'mousewheel' )
		        ->setLabel( esc_html__( 'Mousewheel', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enables navigation through slides using mouse wheel.', 'blackdsn' ) )
		        ->get();

		$control->addSwitcher( 'slideToClickedSlide' )
		        ->setLabel( esc_html__( 'Slide To Clicked Slide', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Set to true and click on any slide will produce transition to this slide', 'blackdsn' ) )
		        ->get();


		$this->end_controls_section();

		$this->start_controls_section(
			'setting_autoplay_swiper_section',
			[
				'label'     => esc_html__( 'AutoPlay Option', 'blackdsn' ),
				'tab'       => Controls_Manager::TAB_SETTINGS,
				'condition' => $this->condition_parallax
			]
		);


		$control->addSwitcher( 'autoplay' )
		        ->setLabel( esc_html__( 'autoplay', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Object with autoplay parameters or boolean true to enable with default settings', 'blackdsn' ) )
		        ->get();

		$control->addNumber( 'delay', 0, '', 1000 )
		        ->setLabel( esc_html__( 'delay', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Distance between slides in px.', 'blackdsn' ) )
		        ->setDefault( 2000 )
		        ->setConditions( 'autoplay', '1' )
		        ->get();

		$control->addSwitcher( 'disableOnInteraction' )
		        ->setLabel( esc_html__( 'Disable On Interaction', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Set to false and autoplay will not be disabled after user interactions (swipes), it will be restarted every time after interaction', 'blackdsn' ) )
		        ->setDefault( '1' )
		        ->setConditions( 'autoplay', '1' )
		        ->get();

		$control->addSwitcher( 'reverseDirection' )
		        ->setLabel( esc_html__( 'Reverse Direction', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enables autoplay in reverse direction', 'blackdsn' ) )
		        ->setConditions( 'autoplay', '1' )
		        ->get();

		$control->addSwitcher( 'stopOnLastSlide' )
		        ->setLabel( esc_html__( 'Stop On Last Slide', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'blackdsn' ) )
		        ->setConditions( 'autoplay', '1' )
		        ->get();


		$control->addSwitcher( 'waitForTransition' )
		        ->setLabel( esc_html__( 'Wait For Transition', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'When enabled autoplay will wait for wrapper transition to continue. Can be disabled in case of using Virtual Translate when your slider may not have transition', 'blackdsn' ) )
		        ->setDefault( '1' )
		        ->setConditions( 'autoplay', '1' )
		        ->get();


		$this->end_controls_section();

	}


	protected function _content_pagination_Navigation() {


		$control = $this->getControl();

		$this->start_controls_section(
			'paginate_swiper_section',
			[
				'label' => esc_html__( 'Pagination & Navigation', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control->addSelect( 'show_navigation', [
			''       => esc_html__( 'None', 'blackdsn' ),
			'1'      => esc_html__( 'Show', 'blackdsn' ),
			'custom' => esc_html__( 'Custom', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( "Navigation (Arrow)", 'blackdsn' ) )
		        ->get();

		$control->addSelectDsn( 'show_navigation_custom', [
			'' => esc_html__( 'None', 'blackdsn' )
		], [ 'target' => 'SWIPER_ARROW' ] )
		        ->setLabel( esc_html__( "Choose Arrow", 'blackdsn' ) )
		        ->setConditions( 'show_navigation', 'custom' )
		        ->get();


		$control->addSelect( 'show_pagination', [
			''            => esc_html__( 'None', 'blackdsn' ),
			'bullets'     => esc_html__( 'bullets', 'blackdsn' ),
			'fraction'    => esc_html__( 'fraction', 'blackdsn' ),
			'progressbar' => esc_html__( 'progressbar', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( 'Pagination', 'blackdsn' ) )
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'type_bullets', [
			''                  => esc_html__( 'Style 1', 'blackdsn' ),
			'dsn-swiper-circle' => esc_html__( 'Style 2', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( 'Type Bullets', 'blackdsn' ) )
		        ->setDefault( '' )
		        ->setConditions( 'show_pagination', 'bullets' )
		        ->get();


		$this->add_control(
			'dsn_width_nav_layout',
			[
				'label'   => __( 'Width Layout', 'blackdsn' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					''              => __( 'Default', 'blackdsn' ),
					'dsn-container' => __( 'Wide Page', 'blackdsn' ),
					'container'     => __( 'Container Page', 'blackdsn' ),
				]
			]
		);

		$control->getJustifyContent( 'justify_content', '.dsn-swiper-paginate' )
		        ->setDefault( 'space-between' )
		        ->setConditions( 'show_navigation', '===', '1' )
		        ->setConditions( 'show_pagination', '!=', '' )
		        ->getResponsive();

		$control->addSlider( 'dsn-swiper-paginate-space', [
			'label' => esc_html__( 'Spacing', 'blackdsn' ),
			'range' => [
				'px' => [ 'max' => 100, ],
			],
		] )
		        ->setSelectors( '.dsn-swiper-paginate', 'margin-top:{{SIZE}}{{UNIT}}' )
		        ->setConditions( 'show_navigation', '===', '1' )
		        ->setConditions( 'show_pagination', '!=', '' )
		        ->getResponsive();

		$this->end_controls_section();

	}

	public function get_content_paginate_render( $attr = null ) {
		$out             = '';
		$show_navigation = $this->shortcode->getVal( 'show_navigation' ) === "1";
		$show_pagination = $this->shortcode->getVal( 'show_pagination' );
		$type_bullets    = $this->shortcode->getVal( 'type_bullets' );

		if ( $this->shortcode->getVal( 'show_navigation' ) === 'custom' ) {
			$this->add_render_attribute( 'arrow_custom', [
				'style'       => 'display:none;',
				'class'       => 'dsn-arrow-custom',
				'data-dsn-id' => $this->shortcode->getVal( 'show_navigation_custom' )
			] );
			printf( '<div %s></div>', $this->get_render_attribute_string( 'arrow_custom' ) );
		}

		if ( ! $show_navigation && ! $show_pagination ) {
			return '';
		}

		if ( $show_navigation ) {
			$out .= '<div class="swiper-prev">
                                            <div class="prev-container">
                                                <div class="container-inner">
                                                    <div class="triangle"></div>
                                                    <svg class="circle" xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24">
                                                        <g class="circle-wrap" fill="none" stroke-width="1"
                                                            stroke-linejoin="round" stroke-miterlimit="10">
                                                            <circle cx="12" cy="12" r="10.5"></circle>
                                                        </g>
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>';
		}

		if ( $show_pagination ) {
			$out .= sprintf( '<div class="swiper-pagination %s mr-30 ml-30 heading-color" data-dsn-type="%s"></div>', $type_bullets, $show_pagination );
		}

		if ( $show_navigation ) {
			$out .= '<div class="swiper-next">
                                        <div class="next-container">
                                            <div class="container-inner">
                                                <div class="triangle"></div>
                                                <svg class="circle" xmlns="http://www.w3.org/2000/svg" width="24"
                                                     height="24" viewBox="0 0 24 24">
                                                    <g class="circle-wrap" fill="none" stroke-width="1"
                                                       stroke-linejoin="round" stroke-miterlimit="10">
                                                        <circle cx="12" cy="12" r="10.5"></circle>
                                                    </g>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>';
		}

		$this->add_render_attribute( 'dsn_swiper_paginate', 'class', [
			'dsn-swiper-paginate  d-flex p-relative w-100 h-100 mt-30 align-items-center',
			$this->shortcode->getVal( 'dsn_width_nav_layout', '' )
		] );
		$this->add_render_attribute( 'dsn_swiper_paginate', 'class', $this->shortcode->getVal( 'justify_content', 'justify-content-between' ) );

		if ( $attr !== null && is_array( $attr ) ) {
			$this->add_render_attribute( 'dsn_swiper_paginate', $attr );
		}


		return sprintf( '<div %1$s >%2$s</div>', $this->get_render_attribute_string( 'dsn_swiper_paginate' ), $out );

	}


	/**
	 * @param blackdsnShortCode $shortcode
	 *
	 * @return array
	 */
	public function getOptionSlider( blackdsnShortCode $shortcode ) {


		$this->shortcode = $shortcode;


		$this->setOptionSwiperResponsiveNumberSlider( 'spaceBetween', 0 );


		$this->setOptionSwiperBoolean( 'allowTouchMove', '1' )
		     ->setOptionSwiperResponsiveBoolean( 'centeredSlides', '' );


		$this->setOptionSwiper( 'direction', 'horizontal' )
		     ->setOptionSwiperBoolean( 'autoHeight' )
		     ->setOptionSwiperBoolean( 'slideToClickedSlide', '' )
		     ->setOptionSwiperBoolean( 'grabCursor', '' )
		     ->setOptionSwiperBoolean( 'mousewheel', '' )
		     ->setOptionSwiperBoolean( 'loop', '' )
		     ->setOptionSwiperBoolean( 'parallax', '' )
		     ->setOptionSwiperResponsiveNumberSlider( 'slidesPerGroup', 1 )
		     ->setOptionSwiperResponsiveNumberSlider( 'slidesPerView', 1 )
		     ->setOptionSwiperResponsiveNumberSlider( 'speed', 1000 )
		     ->setOptionSwiper( 'effect', 'slide' );


		if ( $this->shortcode->getVal( 'autoplay' ) ) {
			$this->autoPlay( 'delay', 2000, false );
			$this->autoPlay( 'disableOnInteraction', '1' );
			$this->autoPlay( 'reverseDirection' );
			$this->autoPlay( 'stopOnLastSlide' );
			$this->autoPlay( 'waitForTransition', '1' );
		}

		if ( $this->swiper_option["direction"] !== "horizontal" ) {
			$this->swiper_option["autoHeight"] = false;
		}

		return $this->swiper_option;
	}


	public function start_swiper( $has_parallax_image = false ) {


		$this->add_render_attribute( 'dsn-swiper', [
			'class'           => 'blackdsn-swiper-slider dsn-swiper p-relative',
			'data-dsn-option' => json_encode( $this->getOptionSlider( new blackdsnShortCode( array( 'widget-base' => $this ) ) ) ),
		] );
		if ( $has_parallax_image ) {
			$this->add_render_attribute( 'dsn-swiper', 'class', 'has-parallax-image' );
		}
		echo '<div ' . $this->get_render_attribute_string( 'dsn-swiper' ) . '><div class="swiper"><div class="swiper-wrapper">';
	}

	public function end_swiper( $with_control = true ) {
		echo '</div>';
		if ( $with_control ) {
			echo $this->get_content_paginate_render();
		}
		echo '</div></div>';
	}

	protected function add_render_swiper_item( $element = 'swiper-slid' ) {
		$this->add_render_attribute( $element, 'class', 'swiper-slide' );
	}


	protected function setFilterSwiper() {
		$this->getControl()->addSwitcher( 'filter_bluer' )
		     ->setLabel( esc_html__( "Filter Blur Swiper", "blackdsn" ) )
		     ->setReturn_value( 'filter-swiper-blur' )
		     ->setPrefix_class()
		     ->get();
	}


	public function get_style_depends(): array {
		return $this->getDepends();
	}

	public function get_script_depends(): array {
		return $this->getDepends();
	}

	private function getDepends(): array {
		return [ blackdsnFrontEnd::FANCYBOX, blackdsnFrontEnd::SWIPER ];
	}

}