<?php

namespace Dsn\Element;


use Elementor\Element_Base;

trait BlackdsnRenderSectionElement {


	private $block = [];

	public function registerRenderSection() {
		/**
		 * Render For Element
		 * col { _inner_wrapper , _widget_wrapper , _background_overlay }
		 */
		add_action( 'elementor/frontend/section/before_render', [ $this, 'render_before_section' ], 10, 2 );
		add_action( 'elementor/frontend/column/before_render', [ $this, 'render_before_section' ] );
		add_action( 'elementor/frontend/widget/before_render', [ $this, 'render_widget_motion_effect' ] );
		add_action( 'elementor/widget/print_template', [ $this, 'motion_effect_print_templete' ], 10, 2 );


	}


	public function motion_effect_print_templete( $template_content, Element_Base $widget ) {


		if ( ! $template_content )
			return $template_content;


		$dsn_content      = blackdsn_shortcode_render( 'blackdsn_animation', [] );
		$dsn_content      = str_replace( "<script>", "<#", $dsn_content );
		$dsn_content      = str_replace( "</script>", "#>", $dsn_content );
		$template_content .= $dsn_content;

		return $template_content;
	}

	public function render_widget_motion_effect( Element_Base $element ) {
		blackdsn_render_widget_motion_effect( $element );
	}


	public function render_before_section( Element_Base $element ) {


		$settings = $element->get_settings();


		$is_section = $element->get_name() === 'section';
		$is_column  = $element->get_name() === 'column';


		if ( $is_column ) {
			$this->getColumn( $element );
			blackdsn_render_widget_motion_effect( $element );

		}

		if ( $is_section ) {
			$this->getSection( $element );
			$this->addPaginate( $element );

		}


		if ( $this->getOptionArray( $settings, 'dsn_change_color' ) ) {
			$element->add_render_attribute( '_wrapper', 'data-dsn', 'color' );
			$element->add_render_attribute( '_wrapper', 'data-dsn-triggerhook',
				$this->getOptionArray( $settings, 'triggerhook_change_color', 'top' ) );
		}


	}


	private function addPaginate( Element_Base $element ) {
		$settings             = $element->get_settings();
		$use_section_paginate = $this->getOptionArray( $settings, 'use_section_paginate' );
		$text_paginate        = $this->getOptionArray( $settings, 'text_paginate' );

		if ( $use_section_paginate && $text_paginate ) {
			$element->add_render_attribute( '_wrapper', 'data-dsn-title', $text_paginate );
		}

	}


	private function getOptionArray( $options, $id, $default = false ) {
		return blackdsn_get_option_array( $options, $id, $default );
	}

	private function getVal( $id, $default = false ) {
		return $this->getOptionArray( $this->block, $id, $default );
	}


	private function getColumn( Element_Base $element ) {
		$settings = $element->get_settings();


		if ( $this->getOptionArray( $settings, 'data_animation_section' ) ) {
			$element->add_render_attribute( '_wrapper', 'data-dsn-animate', 'section' );
		}

	}

	private function getSection( Element_Base $element ) {
		$element->add_render_attribute( 'parallax', 'class', 'h-100' );
		if ( $img = blackdsn_shortcode_render_group( 'image', array( 'widget-base' => $element ) ) ) {
			printf( '<div class="dsn-bg-section p-absolute w-100 h-100 over-hidden hidden top-0 left-0 " data-dsn="bg_section">%s</div>', $img );
		}


	}
}