<?php

namespace Dsn\Element;


use BlackdsnControl;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Element_Base;


class BlackdsnRegisterElement {

	use BlackdsnRenderSectionElement;


	public function registerWidgetSection() {

		/**
		 * Add Controller For Element
		 */
		add_action( 'elementor/element/section/section_layout/before_section_start',
			[ $this, 'register_widgets_before_section' ], 10, 2 );

		add_action( 'elementor/element/column/layout/before_section_start',
			[ $this, 'register_widgets_before_section' ], 10, 2 );

		add_action( 'elementor/element/after_section_end',

			[ $this, 'render_motion_effect' ], 10, 2 );

	}


	public function render_motion_effect( Controls_Stack $element, $section_id ) {


		if ( ! $element instanceof Element_Base || 'section_custom_attributes_pro' !== $section_id ) {
			return;
		}


		$control = new BlackdsnControl( $element );

		$element->start_controls_section(
			'dsn_motion_effect',
			[
				'tab'   => Controls_Manager::TAB_ADVANCED,
				'label' => esc_html__( 'DSN Motion Effect', 'blackdsn' ),
			]
		);


		$control->addSwitcher( 'use_motion_effect' )
		        ->setLabel( esc_html__( 'Scrolling Effects', 'blackdsn' ) )
		        ->get();


		$control->addText( 'use_trigger' )
		        ->setLabel( esc_html__( 'Trigger', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'The element (or selector text for the element) whose position in the normal document flow is used to calculate where the ScrollTrigger starts. ',
			        'blackdsn' ) )
		        ->setConditions( 'use_motion_effect', '1' )
		        ->get();

		$control->addText( 'use_scrub' )
		        ->setLabel( esc_html__( 'Scrub', 'blackdsn' ) )
		        ->setDescription( esc_html__( "smooth scrubbing is empty ( don't animate the pinned element itself because that will throw off the measurements )",
			        'blackdsn' ) )
		        ->setConditions( 'use_motion_effect', '1' )
		        ->get();

		$control->addText( 'use_start' )
		        ->setLabel( esc_html__( 'Start', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Space Start Top', 'blackdsn' ) )
		        ->setDefault( '100%' )
		        ->setConditions( 'use_motion_effect', '1' )
		        ->get();

		$control->addText( 'use_end' )
		        ->setLabel( esc_html__( 'End', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Space End Bottom', 'blackdsn' ) )
		        ->setDefault( '0%' )
		        ->setConditions( 'use_motion_effect', '1' )
		        ->get();


		$control->addSwitcher( 'use_pin' )
		        ->setLabel( esc_html__( 'Pin', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'pin the trigger element while active', 'blackdsn' ) )
		        ->setConditions( 'use_motion_effect', '1' )
		        ->get();

		$control->addSwitcher( 'use_markers' )
		        ->setLabel( esc_html__( 'Markers', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'Adds markers that are helpful during development/troubleshooting. ', 'blackdsn' ) )
		        ->setConditions( 'use_motion_effect', '1' )
		        ->get();


		$slection = [
			'x'       => esc_html__( 'Vertical Scroll', 'blackdsn' ),
			'y'       => esc_html__( 'Horizontal Scroll', 'blackdsn' ),
			'scaleX'  => esc_html__( 'Vertical Scale', 'blackdsn' ),
			'scaleY'  => esc_html__( 'Horizontal Scale', 'blackdsn' ),
			'scale'   => esc_html__( 'Vertical & Horizontal Scale', 'blackdsn' ),
			'rotateX' => esc_html__( 'Vertical Rotate', 'blackdsn' ),
			'rotateY' => esc_html__( 'Horizontal Rotate', 'blackdsn' ),
			'rotate'  => esc_html__( 'Vertical & Horizontal Rotate', 'blackdsn' ),
			'skewX'   => esc_html__( 'Vertical Skew', 'blackdsn' ),
			'skewY'   => esc_html__( 'Horizontal Skew', 'blackdsn' ),
			'skew'    => esc_html__( 'Vertical & Horizontal Skew', 'blackdsn' ),
			'opacity' => esc_html__( 'Transparency', 'blackdsn' ),
			'custom'  => esc_html__( 'Custom', 'blackdsn' ),
		];


		foreach (
			[
				'from' => esc_html__( 'Animation From', 'blackdsn' ),
				'to'   => esc_html__( 'Animation To', 'blackdsn' )
			] as $key => $value
		):
			$control->startRepeater();


			$control->get_element_base()->add_control(
				'important_note',
				[
					'type'      => \Elementor\Controls_Manager::RAW_HTML,
					'raw'       => esc_html__( 'Use Value as Number and Optional Unit. like(10px , 10 , 10% , 100vw)',
						'blackdsn' ),
					'condition' => [
						'key' => [ 'x', 'y' ]
					]
				]
			);

			$control->get_element_base()->add_control(
				'important_note_number',
				[
					'type'      => \Elementor\Controls_Manager::RAW_HTML,
					'raw'       => esc_html__( 'Use Number only', 'blackdsn' ),
					'condition' => [
						'key' => [
							'scaleX',
							'scaleY',
							'scale',
							'rotate',
							'rotateX',
							'rotateY',
							'skew',
							'skewX',
							'skewY'
						]
					]
				]
			);

			$control->get_element_base()->add_control(
				'important_note_opacity',
				[
					'type'      => \Elementor\Controls_Manager::RAW_HTML,
					'raw'       => esc_html__( 'Use Number only from 0 to 1', 'blackdsn' ),
					'condition' => [
						'key' => [ 'opacity' ]
					]
				]
			);

			$control->addSelect2( 'key', $slection )
			        ->setLabel( esc_html__( "Property", "blackdsn" ) )
			        ->setLabelBlock()
			        ->setSeparatorBefore()
			        ->get();


			$control->addText( 'custom' )
			        ->setLabel( esc_html__( "Property Custom", 'blackdsn' ) )
			        ->setConditions( 'key', 'custom' )
			        ->get();

			$control->addText( 'value' )
			        ->setLabel( esc_html__( "Value", 'blackdsn' ) )
			        ->setDefault( 0 )
			        ->getResponsive();


			$control->endRepeater( 'items_' . $key )
			        ->setLabel( $value )
			        ->setTitle_field( 'key' )
			        ->setConditions( 'use_motion_effect', '1' )
			        ->setSeparatorBefore()
			        ->get();

		endforeach;


		$control->addSelect2( 'dsn_animation_layout', [
			'desktop' => esc_html__( 'Desktop', 'blackdsn' ),
			'tablet'  => esc_html__( 'Tablet', 'blackdsn' ),
			'mobile'  => esc_html__( 'Mobile', 'blackdsn' ),
		] )
		        ->setMultiple()
		        ->setLabelBlock()
		        ->setDefault( array( 'desktop', 'tablet', 'mobile' ) )
		        ->setSeparator( "before" )
		        ->setLabel( esc_html__( 'Apply Effects On', 'blackdsn' ) )
		        ->get();

		$element->end_controls_section();

	}

	/** @var Controls_Stack $element */
	public function register_widgets_before_section( Controls_Stack $element ) {


		$control = new BlackdsnControl( $element );

		$is_section = $element->get_name() === 'section';
		$is_column  = $element->get_name() === 'column';


		$element->start_controls_section(
			'blackdsn_section_space',
			[
				'tab'   => Controls_Manager::TAB_SETTINGS,
				'label' => __( 'blackdsn Style', 'blackdsn' ),
			]
		);


		/**
		 *  Add Padding & Margin in (Section , Column)
		 */
		$this->addSpaceSection( $element, $control );

		$element->add_control( 'hr_1', [ 'type' => Controls_Manager::DIVIDER ] );

		/**
		 * screen length
		 * $this->addLayout( $element, [ 'full-width' => esc_html__( 'Ful Width', 'blackdsn' ) ] );
		 */
		$this->addLayout( $element );

		$element->add_control( 'hr_2', [ 'type' => Controls_Manager::DIVIDER ] );
		$this->addStyleBg( $element );

		$element->end_controls_section();


		if ( $is_column ) {
			$this->column_widget( $element );

		}


		if ( $is_section ) {
			$this->section_widget( $element, $control );
			$this->paginationRight( $control, $element );
		}


	}


	private function paginationRight( BlackdsnControl $control, Controls_Stack $element ) {
		$element->start_controls_section(
			'blackdsn_right_paginate',
			[
				'tab'   => Controls_Manager::TAB_SETTINGS,
				'label' => __( 'Right Pagination', 'blackdsn' ),
			]
		);

		$control->addSwitcher( 'use_section_paginate' )
		        ->setLabel( esc_html__( "Use Section Paginate", 'blackdsn' ) )
		        ->setReturn_value( "1" )
		        ->get();

		$control->addText( 'text_paginate' )
		        ->setLabel( esc_html__( "Text Paginate", 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setConditions( 'use_section_paginate', '1' )
		        ->get();

		$element->end_controls_section();

	}


	/**
	 * @param $element
	 * Margin And Padding Section
	 */
	private function addSpaceSection( $element, BlackdsnControl $control ) {

		$element->add_control(
			'dsn_col_margin',
			[
				'label' => __( 'Margin', 'blackdsn' ),

				'type'         => Controls_Manager::CHOOSE,
				'options'      => [
					'mt-section'     => [
						'title' => __( 'Margin Top', 'blackdsn' ),
						'icon'  => 'eicon-v-align-top',
					],
					'section-margin' => [
						'title' => __( 'Margin Top & Bottom ', 'blackdsn' ),
						'icon'  => 'eicon-v-align-middle',
					],

					'mb-section' => [
						'title' => __( 'Margin Bottom', 'blackdsn' ),
						'icon'  => 'eicon-v-align-bottom',
					],

				],
				'default'      => '',
				'prefix_class' => '',
			]
		);

		$element->add_control(
			'dsn_col_padding',
			[
				'label' => __( 'Padding', 'blackdsn' ),

				'type'         => Controls_Manager::CHOOSE,
				'options'      => [
					'pt-section'      => [
						'title' => __( 'Padding Top', 'blackdsn' ),
						'icon'  => 'eicon-v-align-top',
					],
					'section-padding' => [
						'title' => __( 'Padding Top & Bottom', 'blackdsn' ),
						'icon'  => 'eicon-v-align-middle',
					],

					'pb-section' => [
						'title' => __( 'Padding Bottom', 'blackdsn' ),
						'icon'  => 'eicon-v-align-bottom',
					],

				],
				'default'      => '',
				'prefix_class' => '',
			]
		);

		if ( $element->get_name() !== 'column' )
			return;

		$control->addSwitcher( 'dsn_custom_gap' )
		        ->setReturn_value( "dsn-column-gap-custom" )
		        ->setLabel( esc_html__( "Gap Columns", "blackdsn" ) )
		        ->setPrefix_class()
		        ->get();

		$control->addSwitcher( 'dsn_custom_gap_text' )
		        ->setLabel( esc_html__( "Use Manuel Custom Gaps", "blackdsn" ) )
		        ->setConditions( 'dsn_custom_gap', '!=', '' )
		        ->get();


		$control->addText( 'dsn_col_number_col_text' )
		        ->setLabel( esc_html__( "Columns Template Gap", 'blackdsn' ) )
		        ->setSelectors( '> div', 'grid-template-columns: {{VALUE}};' )
		        ->setConditions( 'dsn_custom_gap', '!=', '' )
		        ->setLabelBlock()
		        ->setConditions( 'dsn_custom_gap_text', '!=', '', 'and' )
		        ->getResponsive();

		$control->addNumberSlider( 'dsn_col_number_col', 0, 100, 1 )
		        ->setLabel( esc_html__( "Columns Template Gap", 'blackdsn' ) )
		        ->setSelectors( '> div',
			        '-ms-grid-columns: (1fr)[{{SIZE}}];grid-template-columns: repeat({{SIZE}},1fr);' )
		        ->setConditions( 'dsn_custom_gap', '!=', '' )
		        ->setConditions( 'dsn_custom_gap_text', '!=', '1', 'and' )
		        ->getResponsive();

		$control->addNumberSlider( 'dsn_col_layout_gap', 0, 100, 1 )
		        ->setSizeUnits( [ 'px', '%', 'vw' ] )
		        ->setLabel( esc_html__( "Columns Gap", 'blackdsn' ) )
		        ->setSelectors( '> div', 'grid-column-gap:{{SIZE}}{{UNIT}};' )
		        ->setConditions( 'dsn_custom_gap', '!=', '' )
		        ->getResponsive();

		$control->addNumberSlider( 'dsn_row_layout_gap', 0, 100, 1 )
		        ->setSizeUnits( [ 'px', '%', 'vh' ] )
		        ->setLabel( esc_html__( "Row Gap", 'blackdsn' ) )
		        ->setConditions( 'dsn_custom_gap', '!=', '' )
		        ->setSelectors( '> div', 'grid-row-gap:{{SIZE}}{{UNIT}};' )
		        ->getResponsive();


	}

	/**
	 * @param $element
	 * @param array $args
	 */
	private function addLayout( $element, array $args = array() ) {


		$option = array_merge( [
			''                                  => __( 'Default', 'blackdsn' ),
			'dsn-container'                     => __( 'Wide Page', 'blackdsn' ),
			'container'                         => __( 'Container Page', 'blackdsn' ),
			'dsn-container dsn-right-container' => __( 'Right Container Page', 'blackdsn' ),
			'dsn-container dsn-left-container'  => __( 'Left Container Page', 'blackdsn' ),
		], $args );

		$element->add_control(
			'dsn_width_layout',
			[
				'label'        => __( 'Width Layout', 'blackdsn' ),
				'type'         => Controls_Manager::SELECT,
				'default'      => '',
				'options'      => $option,
				'prefix_class' => '',
			]
		);

	}


	/**
	 * @param $element Controls_Stack
	 */
	private function addStyleBg( Controls_Stack $element ) {

		$element->add_control(
			'background_dsn_style_ver',
			[
				'label'        => __( 'Version Background Section', 'blackdsn' ),
				'type'         => Controls_Manager::SELECT,
				'default'      => '',
				'description'  => __( 'If you choose the wallpaper version, it is best to choose the type of background section',
					'blackdsn' ),
				'label_block'  => true,
				'options'      => [
					''             => __( 'Default', 'blackdsn' ),
					'v-light'      => __( 'Light', 'blackdsn' ),
					'v-light-head' => __( 'Light (Static)', 'blackdsn' ),
					'v-dark'       => __( 'Dark', 'blackdsn' ),
					'v-dark-head'  => __( 'Dark  (Static)', 'blackdsn' ),
				],
				'prefix_class' => '',

			]
		);

		$element->add_control(
			'background_dsn_style',
			[
				'label'       => __( 'Background Section', 'blackdsn' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'background-transparent',
				'label_block' => true,

				'options'      => [
					'background-transparent' => __( 'Default', 'blackdsn' ),
					'background-main'        => __( 'Background Main', 'blackdsn' ),
					'background-section'     => __( 'Background Section', 'blackdsn' ),
					'background-theme'       => __( 'Background Theme', 'blackdsn' ),
				],
				'prefix_class' => '',

			]
		);


	}


	/** @var Controls_Stack $element */
	private function column_widget( Controls_Stack $element ) {

		$element->start_controls_section(
			'blackdsn_section_animate',
			[
				'tab'   => Controls_Manager::TAB_SETTINGS,
				'label' => __( 'blackdsn Animate', 'blackdsn' ),
			]
		);

		$element->add_control( 'data_animation_section', [
			'label'        => __( 'Animate Section', 'blackdsn' ),
			'type'         => Controls_Manager::SWITCHER,
			'description'  => __( 'you can turn on animation in the children element', 'blackdsn' ),
			'return_value' => '1',
		] );


		$element->end_controls_section();

	}

	/**
	 * @param Controls_Stack $element
	 * @param BlackdsnControl $control ;
	 */
	private function section_widget( Controls_Stack $element, BlackdsnControl $control ) {

		$this->sectionBgControl( $element, $control );
		$this->changeColor( $element, $control );
	}

	/**
	 * @param Controls_Stack $element
	 * @param BlackdsnControl $control ;
	 */
	private function changeColor( Controls_Stack $element, BlackdsnControl $control ) {

		$element->start_controls_section(
			'blackdsn_change_color',
			[
				'tab'   => Controls_Manager::TAB_SETTINGS,
				'label' => __( 'blackdsn Change Color Section', 'blackdsn' ),
			]
		);
		$control->addSwitcher( 'dsn_change_color' )
		        ->setLabel( __( 'Change Color', 'blackdsn' ) )
		        ->get();

		$control->getTriggerHock( 'triggerhook_change_color', 'top' )
		        ->setConditions( 'dsn_change_color', '1' )
		        ->get();

		$element->end_controls_section();


	}

	/**
	 * @param Controls_Stack $element
	 * @param BlackdsnControl $control ;
	 */
	private function sectionBgControl( Controls_Stack $element, BlackdsnControl $control ) {


		$element->start_controls_section(
			'blackdsn_section_bg',
			[
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'blackdsn Parallax Background', 'blackdsn' ),
			]
		);

		$control->addImage()
		        ->setDefault( [] )
		        ->get()
		        ->addImageSize()->getGroup();

		/**
		 * Overlay Bg
		 */
		$control->addPopover( 'opacity_overlay_popover' )
		        ->setLabel( __( "Background Overlay", 'elementor' ) )
		        ->setSeparator( "before" )
		        ->get();

		$element->start_popover();

		$control->addColor( 'color_overlay' )
		        ->setLabel( __( 'Color Overlay' ) )
		        ->get();

		$control->addNumberSlider( 'opacity_overlay', 0, 10, 1 )
		        ->setLabel( __( 'Opacity Overlay' ) )
		        ->setDefaultRange( 4 )
		        ->get();

		$element->end_popover();


		$control->addBlendMode( 'bland_overlay', '.img-box-parallax img' )
		        ->get();


		$control->addPopover( 'position_image' )
		        ->setLabel( __( 'Position Image', 'blackdsn' ) )
		        ->get();
		$element->start_popover();

		$control->addNumber( 'position_image_position_x', 1, 100, 10 )
		        ->setLabel( __( 'Position X', 'blackdsn' ) )
		        ->setDefault( 50 )
		        ->get();


		$control->addNumber( 'position_image_position_y', 1, 100, 10 )
		        ->setLabel( __( 'Position Y', 'blackdsn' ) )
		        ->setDefault( 50 )
		        ->get();

		$element->end_popover();
		$this->getEntranceAnimationImage( $control );

		$element->end_controls_section();


	}


	/**
	 * @param $control BlackdsnControl
	 */
	private function getEntranceAnimationImage( BlackdsnControl $control ) {


		$control->addChoose( 'direction_animate_image' )
		        ->setLabel( __( "Direction", 'blackdsn' ) )
		        ->setOptionChoose( 'has-opposite-direction', __( 'Up', 'blackdsn' ), 'eicon-arrow-up' )
		        ->setOptionChoose( 'has-direction', __( 'Down', 'blackdsn' ), 'eicon-arrow-down' )
		        ->setDefault( 'has-direction' )
		        ->setSeparator( "before" )
		        ->get();

		$control->addSelect( 'animate_image_style', [
			''                 => __( "Default", 'blackdsn' ),
			'has-bigger-scale' => __( "Scale Down", 'blackdsn' ),
			'has-scale'        => __( "Scale Up", 'blackdsn' ),
		] )
		        ->setLabel( __( "Entrance Animation Type", 'blackdsn' ) )
		        ->setDefault( '' )->get();


		$control->getTriggerHock( 'animate_image_triggerhook' )
		        ->get();


		$control->addNumberSlider( 'speed_animation_image', 0, 100, 10 )
		        ->setDefaultRange( 30 )
		        ->setLabel( __( 'Speed', 'blackdsn' ) )
		        ->get();

	}


}