<?php

namespace Dsn\Element;


use blackdsnShortCode;
use Elementor\Widget_Base;

class  BlackdsnLayout extends Widget_Base {

	use Blackdsn_Widget_Base;

	private $swiper_option = array();


	/**
	 * @var null|blackdsnShortCode
	 */
	private $shortcode = null;

	protected $style_item = '.dsn-grid-layout';
	protected $style_layout = '.dsn-grid-layout';
	protected $default_mobile = true;

	protected $range_col = 30;
	protected $range_row = 50;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_layouts';
	}


	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'blackdsn' ] );
	}

	/**
	 * @return array
	 */
	protected function getLayoutStyle(): array {
		return array(
			'dsn-grid'                                        => esc_html__( "Grid", 'blackdsn' ),
			'dsn-isotope'                                     => esc_html__( "Masonry", 'blackdsn' ),
			'dsn-masonry-grid dsn-isotope'                    => esc_html__( "Masonry Grid", 'blackdsn' ),
			'dsn-masonry-grid dsn-masonry-grid-2 dsn-isotope' => esc_html__( "Masonry Grid 2", 'blackdsn' ),
		);
	}

	public function add_parallax_attributes( $element, $id, blackdsnShortCode $shortcode ): BlackdsnLayout {
		$this->shortcode = $shortcode;
		if ( ! $this->shortcode->getVal( 'parallax' ) ) {
			return $this;
		}

		$parallax = $this->shortcode->getVal( 'parallax_' . $id, array( 'unit' => '%', 'size' => 0 ) );
		$size     = $this->shortcode->getOptionArray( $parallax, 'size' );
		if ( $size ):
			$unit = $this->shortcode->getOptionArray( $parallax, 'unit', '%' );
			if ( $unit !== '%' ) {
				$unit = '';
			}

			$this->add_render_attribute( $element, 'data-swiper-parallax', $size . $unit );
		endif;
		$scale = $this->shortcode->getValueNumberSlide( 'scale_' . $id, 1 );

		if ( $scale !== 1 && $scale !== '' ) {
			$this->add_render_attribute( $element, 'data-swiper-parallax-scale', $scale );
		}

		$opacity = $this->shortcode->getValueNumberSlide( 'opacity_' . $id, 1 );
		if ( $opacity < 1 && $opacity !== '' ) {
			$this->add_render_attribute( $element, 'data-swiper-parallax-opacity', $opacity );
		}

		if ( $duration_ = $this->shortcode->getValueNumberSlide( 'duration_' . $id ) ) {
			$this->add_render_attribute( $element, 'data-swiper-parallax-duration', $duration_ );
		}


		$this->add_render_attribute( $element, 'class', 'dsn-swiper-parallax-transform' );

		return $this;
	}


	public function addPrefixClassLayout( $element, blackdsnShortCode $shortcode ) {

		$with_def = '';
		if ( ! $this->default_mobile ) {
			$with_def = 'dsn-n-default';
		}


		$this->add_render_attribute( $element, [
			'class' => [
				'dsn-grid-layout',
				$with_def,
				$shortcode->getVal( 'layout_style', 'dsn-grid' ),
				$shortcode->getVal( 'full_width_last_item', '' ),
			],

			'data-dsn-iso' => $this->get_id(),

		] );


	}

	public function addAnimateFade( $element, blackdsnShortCode $shortcode ) {
		if ( $shortcode->getVal( 'use_animate_fade' ) ) {
			$this->add_render_attribute( $element, 'class', 'dsn-up' );
		}
	}


	protected function getLayout() {

		$control = $this->getControl();
//
//		$control->addHidden( 'init_layout' )
//		        ->setDefault( true )
//		        ->setSelectors( '', 'position: relative;overflow: hidden;' )
//		        ->get();

		$control->addSelect( 'layout_style', $this->getLayoutStyle() )
		        ->setLabel( esc_html__( "Layout Style", 'blackdsn' ) )
		        ->setDefault( "dsn-grid" )
		        ->setSeparator( "before" )
		        ->get();


		$control->addNumberSlider( 'number_blackdsn', 1, 9, 1 )
		        ->setLabel( esc_html__( "Columns", 'blackdsn' ) )
		        ->setDefaultRange( 1 )
		        ->setSelectors( $this->style_layout, '--dsn-width-item: {{SIZE}};' )
		        ->getResponsive();

		$control->addSwitcher( 'full_width_last_item' )
		        ->setLabel( esc_html__( "full width last item", 'blackdsn' ) )
		        ->setReturn_value( "full-width-last-item" )
		        ->setConditions( 'layout_style', '!=', 'dsn-isotope' )
		        ->get();

		$control->addSwitcher( 'use_animate_fade' )
		        ->setLabel( esc_html__( "use Animate Fade", 'blackdsn' ) )
		        ->setReturn_value( "dsn-layout-fade-up" )
		        ->setPrefix_class()
		        ->get();


	}

	protected function getGridSpace() {
		$control = $this->getControl();
		$control->addNumberSlider( 'col_layout_gap', 0, 100, 1 )
		        ->setLabel( esc_html__( "Columns Gap", 'blackdsn' ) )
		        ->setSelectors( $this->style_layout, '--dsn-col-item: {{SIZE}}px;' )
		        ->setDefaultRange( $this->range_col )
		        ->getResponsive();

		$control->addNumberSlider( 'row_layout_gap', 0, 100, 1 )
		        ->setLabel( esc_html__( "Row Gap", 'blackdsn' ) )
		        ->setSelectors( $this->style_layout, '--dsn-row-item: {{SIZE}}px;' )
		        ->setDefaultRange( $this->range_row )
		        ->getResponsive();


	}


}