<?php

namespace Dsn\Blackdsn\Element;


use BlackdsnControl;

trait  BrandControl {

	public function __content_controller( BlackdsnControl $control ) {


		$control->addImageSize()
		        ->setDefault( 'thumbnail' )
		        ->getGroup();


		$control->startRepeater();
		$control->addImage()->get();

		$control->addSelect( 'border_type', [
			''                           => esc_html__( 'Default', 'blackdsn' ),
			'border-bottom border-right' => esc_html__( 'Bottom Right', 'blackdsn' ),
			'border-right'               => esc_html__( 'Right', 'blackdsn' ),
			'border-bottom'              => esc_html__( 'Bottom', 'blackdsn' ),
		] )
		        ->setLabel( esc_html__( "Border Type", 'blackdsn' ) )
		        ->setDefault( '' )
		        ->get();


		$control->addLink( 'link' )
		        ->setLabel( esc_html__( 'Link', 'blackdsn' ), true )
		        ->setDefault_url()
		        ->setDefault_is_external( true )
		        ->setDefault_is_nofollow( true )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( "Items" )
		        ->setTitle_field_WithImage( 'image', 'link.url' )
		        ->get();


	}

	public function __style_controller( BlackdsnControl $control ) {
		$control->addSelect( 'bg_ver_btn', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background Service', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_btn', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Service', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-section' )
		        ->get();

		$control->addPaddingGroup( 'item_padding', '.brand-item' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius', '.brand-item' )
		        ->getResponsive();

		$control->addBorder( 'item_border_style', '.brand-item' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow', '.brand-item' )->getGroup();

	}

}