<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnSwiperBrand extends \Dsn\Element\BlackdsnSlider {

	use \Dsn\Element\Blackdsn_Widget_Base;
	use \Dsn\Blackdsn\Element\BrandControl;


	protected $parallax = array();
	protected $style_item = '.brand-item-inner';

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_brand_slider';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Brand Swiper', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-instagram-nested-gallery';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'Brand', 'Icon' ] );
	}


	protected function register_controls() {
		$this->parallax = array(
			'content' => esc_html__( "content", 'blackdsn' )
		);
		parent::register_controls(); // TODO: Change the autogenerated stub


		$this->styleTab();

		$this->remove_control( 'item_padding' );
		$this->remove_control( 'border_radius' );
		$this->remove_control( 'border_border' );
		$this->remove_control( 'button_box_shadow_box_shadow_type' );

		$this->remove_control( 'bg_color_item' );
		$this->remove_control( 'bg_ver_item' );
		$this->remove_control( 'bg_item' );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {


		$this->__content_controller( $this->getControl() );

	}


	private function styleTab() {


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);


		$this->__style_controller( $this->getControl() );

		$this->end_controls_section();


	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$items_key = $this->getKeys( 'items', [ 'title', 'description' => 'advanced', 'text_link' ] );
		$this->add_render_swiper_item( 'brand-item' );
		$this->add_render_attribute( 'dsn-brand', 'class', 'dsn-brand' );

		echo '<div ' . $this->get_render_attribute_string( 'dsn-brand' ) . '>';
		$this->start_swiper();
		echo blackdsn_shortcode_render_group( 'brand', array( 'widget-base' => $this ), $items_key );
		$this->end_swiper();
		echo '</div>';


	}


}
