<?php

use Dsn\Blackdsn\Element\BrandControl;
use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnLayout;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class  BlackdsnGridBrand extends BlackdsnLayout {

	use Blackdsn_Widget_Base;
	use BrandControl;

	protected $style_item = '.brand-item-inner';


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_brand';

	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Brand', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-instagram-nested-gallery';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'Brand', 'Icon' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Brand Content', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$this->getLayout();
		$this->__content_controller( $control );

		$this->end_controls_section();

		$this->styleTab();

	}


	private function styleTab() {
		$control = $this->getControl();


		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->getGridSpace();
		$this->__style_controller( $control );


		$this->end_controls_section();


	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$control   = new blackdsnShortCode( array( 'widget-base' => $this ) );
		$items_key = $this->getKeys( 'items', [ 'text_link' => 'none' ] );
		$this->addPrefixClassLayout( 'dsn-brand', $control );
		$this->addAnimateFade( 'brand-item', $control );
		$this->add_render_attribute( 'dsn-brand', 'class', 'dsn-brand' );

		echo '<div ' . $this->get_render_attribute_string( 'dsn-brand' ) . '>';

		echo blackdsn_shortcode_render_group( 'brand', array( 'widget-base' => $this ), $items_key );
		echo '</div>';

	}


}
