<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
};

/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class GridaFeature extends \Dsn\Element\GridaLayout {

	use \Dsn\Element\Arctit_Widget_Base;


	protected $range_col = 15;
	protected $range_row = 15;

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_feature';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Grida Feature', 'grida' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-bullet-list';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'feature' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Accordion', 'grida' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$this->getLayout();


		$control->startRepeater();


		$control->get_element_base()->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'elementor' ),
				'type'  => \Elementor\Controls_Manager::ICONS,
			]
		);

		$control->addTextarea( 'text' )
		        ->setDefault( 'Web Design' )
		        ->setLabel( esc_html__( "Text", 'grida' ) )
		        ->setLabelBlock()
		        ->setDynamicActive( true )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( 'List Items', 'grida' ) )
		        ->setTitle_field( 'text' )
		        ->get();


		$this->end_controls_section();

		$this->styleTab();
	}


	private function styleTab() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'grida' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->getGridSpace();

		$control->addSlider( 'width_icon', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Size Icon', 'elementor' ) )
		        ->setSeparatorBefore()
		        ->setSelectors( '.dsn-icon i', 'font-size: {{SIZE}}{{UNIT}};' )
		        ->setSelectors( '.dsn-icon svg', 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};' )
		        ->setSelectors( '.dsn-icon svg path', 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();


		$control->addSelect( 'bg_ver_btn', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background Service', 'grida' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->setSeparatorBefore()
		        ->get();

		$control->addSelect( 'bg_btn', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Service', 'grida' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-section' )
		        ->get();

		$control->addPaddingGroup( 'item_padding_img', '.list-item' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius_img', '.list-item' )
		        ->getResponsive();

		$control->addBorder( 'item_border_style_img', '.list-item' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow_img', '.list-item' )->getGroup();

		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$control = new arctitShortCode( array( 'widget-base' => $this ) );

		$items_key = $this->getKeys( 'items', [ 'text' ] );

		$this->addPrefixClass( 'dsn-feature', $control );
		$this->addAnimateFade( 'list-item', $control );
		$this->add_render_attribute( 'dsn-feature', 'class', 'dsn-feature' );

		echo '<ul ' . $this->get_render_attribute_string( 'dsn-feature' ) . '>';
		echo grida_shortcode_render_group( 'feature', array( 'widget-base' => $this ), $items_key );
		echo '</ul>';

	}


}
