<?php

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnTabs extends \Elementor\Widget_Base
{


    /**
     * Get widget name.
     *
     * Retrieve accordion widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'dsn_tab';
    }


    /**
     * Get widget title.
     *
     * Retrieve accordion widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return __( 'Blackdsn Tab', 'blackdsn' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve accordion widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-tabs';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @return array Widget keywords.
     * @since 2.1.0
     * @access public
     *
     */
    public function get_keywords()
    {
        return [ 'dsn', 'accordion', 'tabs', 'toggle' ];
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the oEmbed widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return [ 'blackdsn_cat' ];

    }

    /**
     * Register accordion widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls()
    {


	    $this->start_controls_section(
		    'content_section',
		    [
			    'label' => esc_html__( 'Content', 'blackdsn' ),
			    'tab'   => Controls_Manager::TAB_CONTENT,
		    ]
	    );


	    $control = $this->getControl();


    }

    /**
     * Render accordion widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {


	    $settings = $this->get_settings_for_display();
        $items    = blackdsn_get_option_array( $settings, 'items', array() );
        if ( !count( $items ) )
            return '';

        foreach ( $items as $index => $item ) :
            $tab_title = $this->get_repeater_setting_key( 'subtitle', 'items', $index );
            $this->add_inline_editing_attributes( $tab_title, 'none' );
            $tab_title = $this->get_repeater_setting_key( 'title_tab', 'items', $index );
            $this->add_inline_editing_attributes( $tab_title, 'none' );
            $tab_title = $this->get_repeater_setting_key( 'title', 'items', $index );
            $this->add_inline_editing_attributes( $tab_title, 'none' );
            $tab_description = $this->get_repeater_setting_key( 'description', 'items', $index );
            $this->add_inline_editing_attributes( $tab_description, 'advanced' );
        endforeach;

//
//        $blackdsn = new blackdsnBlock();
//        echo blackdsn_shortcode_view('tabs' , $blackdsn->getAttrBlock( $this, true ) );

    }


}
