<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnVideo extends \Elementor\Widget_Base {

	use \Dsn\Element\Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_video';

	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Map', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'fas fa-map-marked-alt';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'Map' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$control->addText( 'lat' )
		        ->setLabel( __( 'Latitude', 'blackdsn' ) )
		        ->setDefault( '51.5073509' )
		        ->setPlaceholder( '51.5073509' )
		        ->setDynamicActive( true )
		        ->get();


		$control->addText( 'lng' )
		        ->setLabel( __( 'Longitude', 'blackdsn' ) )
		        ->setDefault( '-0.1277583' )
		        ->setPlaceholder( '-0.1277583' )
		        ->setDynamicActive( true )
		        ->get();


		$this->add_control(
			'zoom',
			[
				'label'   => __( 'Zoom Level', 'blackdsn' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 25,
				'step'    => 1,
				'default' => 14,
			]
		);

		$control->addSwitcher( 'dsn_equal_height', [
			'label'        => __( 'Enable Equal Height', 'blackdsn' ),
			'prefix_class' => 'dsn-equal-height ',
			'default'      => '',
		] )
		        ->setSeparator( "before" )
		        ->setReturn_value( 'h-100' )
		        ->get();


		$control->addSlider( 'height', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height', 'blackdsn' ) )
		        ->setSelectors( '.map-custom', 'height: {{SIZE}}{{UNIT}};' )
		        ->setDefaultRange( 80, 'vh' )
		        ->getResponsive();


		$this->end_controls_section();

//		$this->styleTab();

	}


	private function styleTab() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);


		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		echo blackdsn_shortcode_render_group( 'video', array( 'widget-base' => $this ) );
	}


}
