<?php

use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnSlider;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnTestimonial extends BlackdsnSlider {

	use Blackdsn_Widget_Base;


	protected $parallax = array();

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_testimonial';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Testimonial', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-testimonial';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'testimonial', 'client' ] );
	}


	protected function register_controls() {
		$this->parallax = array(
			'image'       => esc_html__( "Image", 'blackdsn' ),
			'content'     => esc_html__( "content", 'blackdsn' ),
			'description' => esc_html__( "Description", 'blackdsn' ),

		);
		parent::register_controls(); // TODO: Change the autogenerated stub

		$this->getStyleContent();


	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls_content() {


		$control = $this->getControl();


		$control->addSwitcher( 'style_image' )
		        ->setLabel( esc_attr__( 'StyleImage', 'blackdsn' ) )
		        ->setReturn_value( 'image-left-style' )
		        ->setLabel_off( esc_html__( "right", "blackdsn" ) )
		        ->setLabel_on( esc_html__( "left", "blackdsn" ) )
		        ->setPrefix_class()
		        ->get();

		$control->addSwitcher( 'quote_style' )
		        ->setLabel( esc_attr__( 'quote', 'blackdsn' ) )
		        ->setReturn_value( 'quote-box-style' )
		        ->setPrefix_class()
		        ->get();

		$control->addImageSize()
		        ->setDefault( 'thumbnail' )
		        ->setSeparatorAfter()
		        ->getGroup();


		$control->startRepeater();

		$control->addText( "subtitle" )
		        ->setLabel( esc_html__( 'SubTitle', 'blackdsn' ), true )
		        ->setDefault( esc_html__( 'Design Quality', 'blackdsn' ) )
		        ->get();

		$control->addImage()
		        ->get();


		$control->addText( "name" )
		        ->setLabel( esc_html__( 'Name', 'blackdsn' ), true )
		        ->setDefault( esc_html__( 'The Name', 'blackdsn' ) )
		        ->setSeparatorBefore()
		        ->get();

		$control->addText( "position" )
		        ->setLabel( esc_html__( 'Position', 'blackdsn' ), true )
		        ->setDefault( esc_html__( 'The Position', 'blackdsn' ) )
		        ->get();

		$control->addTextarea( "description" )
		        ->setLabel( esc_html__( 'Content', 'blackdsn' ), true )
		        ->setDefault( 'Te qui alii inermis vivendum, an decore libris eum. Te mel dico alia wisi, cu vitae noluisse <a href="#0" target="_blank">phaedrum</a> .' )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( "Items" )
		        ->setTitle_field_WithImage( "image", "name" )
		        ->setSeparator( "before" )
		        ->get();

		$control->getAlign()
		        ->setSeparatorBefore()
		        ->getResponsive();

		$control->getJustifyContent('justify_content_content' , '.dsn-testimonials .content-inner')
		        ->setSeparatorBefore()
		        ->getResponsive();


	}


	private function getStyleContent() {
		$control = $this->getControl();


		$args = array(
			'title-block-lg'       => esc_html__( 'Title', 'blackdsn' ),
			'sub-title-heading'    => esc_html__( 'subtitle', 'blackdsn' ),
			'testimonial-name'     => esc_html__( 'name', 'blackdsn' ),
			'testimonial-position' => esc_html__( 'Position', 'blackdsn' ),
			'testimonial-content'  => esc_html__( 'Content', 'blackdsn' )
		);


		foreach ( $args as $id => $value ):

			$args_tab = [
				'label' => $value,
				'tab'   => Controls_Manager::TAB_STYLE,
			];

			if ( $id === 'sub-title-heading' || $id === 'title-block-lg' ) {
				$args_tab['condition'] = [ 'style_testimonial' => 'testimonial-1' ];
			}

			$this->start_controls_section(
				'style_content_service_' . $id, $args_tab
			);


			$control->addColor( 'color_content_' . $id )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addTypography( 'item_typo_content_' . $id, '.' . $id )
			        ->getGroup();

			$control->addTextShadow( 'text_content_shadow_' . $id, '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;

		$this->start_controls_section( 'style_content_service_image', [
				'label' => esc_html__( 'Image', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'border_image',
				'selector'  => '{{WRAPPER}} .box-img img',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'border_radius_img',
			[
				'label'      => __( 'Border Radius', 'elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .box-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {


		$this->add_inline_editing_attributes( 'title', 'none' );

		$items_key = $this->getKeys( 'items', [
			'description',
			'name'     => 'none',
			'position' => 'none',
			'subtitle' => 'none',
		] );
		echo blackdsn_shortcode_render_group( 'testimonial', array( 'widget-base' => $this ), $items_key );

	}


}
