<?php


use Dsn\Element\Blackdsn_Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnTabs extends Widget_Base {

	use Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_tab';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Tab', 'blackdsn' );

	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-tabs';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'accordion', 'tabs', 'toggle' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$control->startRepeater();


		$control->addText( "title" )
		        ->setLabelBlock()
		        ->setLabel( esc_html__( 'Title', 'blackdsn' ), true )
		        ->setDefault( esc_html__( 'Enter Title', 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->get();

		$control->addTextareaEditor( "description" )
		        ->setLabel( esc_html__( 'Description', 'blackdsn' ), true )
		        ->setDefault( '<p>Te qui alii inermis vivendum, an decore libris eum. Te mel dico alia wisi, cu vitae noluisse <a href="#0" target="_blank">phaedrum</a> .</p>' )
		        ->setDynamicActive( true )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( 'items', 'blackdsn' ) )
		        ->setTitle_field( 'title' )
		        ->get();


		$this->end_controls_section();

//		$this->style_icon();
	}

	private function style_icon() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_content_service_icon',
			[
				'label' => esc_html__( "icon", 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$control->addIconColor( 'icon_color_select' )
		        ->setPrefix_class()
		        ->get();


		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Color', 'elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'condition' => [
					'icon_color_select' => ''
				],
				'selectors' => [
					'{{WRAPPER}} .dsn-icon i'        => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsn-icon svg'      => 'fill: {{VALUE}};',
					'{{WRAPPER}} .dsn-icon svg path' => 'fill: {{VALUE}};',
				],

			]
		);

		$control->addSlider( 'width_icon', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Size Icon', 'elementor' ) )
		        ->setSelectors( '.dsn-socials .dsn-icon', '--dsn-icon-size: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();


		$control->addPaddingGroup( 'item_padding_icon', 'a.init-color' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addBorderRadiusGroup( 'item_border_radius_icon', 'a.init-color' )
		        ->getResponsive();

		$control->addBorder( 'item_border_style_icon', 'a.init-color' )->getGroup();
		$control->addBoxShadow( 'item_box_shadow_icon', 'a.init-color' )->getGroup();

		$this->end_controls_section();
	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {


		$items_key = $this->getKeys( 'items', [ 'title' => "none", 'description' => 'advanced' ] );

		echo blackdsn_shortcode_render_group( 'tabs', array( 'widget-base' => $this ), $items_key );
	}

}
