<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class  BlackdsnSkills extends \Dsn\Element\BlackdsnLayout {


	use \Dsn\Element\Blackdsn_Widget_Base;

	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_skills';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Progress Bar', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-skill-bar';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'progress bar', 'skills' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Progress Info', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$control = $this->getControl();

		$control->addChoose( 'style_skill' )
		        ->setLabel( esc_html__( 'Style', 'blackdsn' ) )
		        ->setOptionChoose( 'p', esc_html__( 'Progress', 'blackdsn' ), 'eicon-menu-bar' )
		        ->setOptionChoose( 'c', esc_html__( 'circle', 'blackdsn' ), 'eicon-circle-o' )
		        ->setDefault( 'p' )
		        ->get();

		$this->getLayout();


		$control->startRepeater();
		$control->addNumber( 'number', 0, null, 1 )
		        ->setLabel( esc_html__( 'Number', 'blackdsn' ) )
		        ->setDefault( 50 )
		        ->get();


		$control->addText( 'title' )
		        ->setLabel( esc_html__( 'Title Skills', 'blackdsn' ), true, false )
		        ->setLabelBlock()
		        ->setDefault( esc_html__( 'Enter Text Skills', 'blackdsn' ) )
		        ->get();


		$control->addTextarea( 'description' )
		        ->setLabel( esc_html__( 'Description', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( esc_html__( 'All kinds of buildings in chematic or working design', 'blackdsn' ) )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( 'List Items', 'blackdsn' ) )
		        ->setTitle_field( 'title' )
		        ->get();


		$this->end_controls_section();

		$this->styleTab();
		$this->getStyleContent();

	}


	private function getStyleContent() {
		$control = $this->getControl();


		$args = array(
			'dsn-title-award'  => esc_html__( 'Title', 'blackdsn' ),
			'dsn-number-skills' => esc_html__( 'Number', 'blackdsn' )
		);

		foreach ( $args as $id => $value ):

			$this->start_controls_section(
				'style_content_service_' . $id,
				[
					'label' => $value,
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);


			$control->addColor( 'color_content_' . $id )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addTypography( 'item_typo_content_' . $id, '.' . $id )
			        ->getGroup();


			$control->addSize( $id );

			if ( $id === 'dsn-number-award' ) {
				$control->setDefault( 'font-number' );
			} else {
				$control->setDefault( 'sm-title-block' );
			}

			$control->get();


			$control->addTextShadow( 'text_content_shadow_' . $id, '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;


	}

	private function styleTab() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style Box Item', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->getGridSpace();


		$control->addSelect( 'bg_ver_item', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background Item', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'bg_item', $control->getOptionBackground( [
			'background-heading' => __( 'Background Heading', 'blackdsn' ),
		] ) )
		        ->setLabel( esc_html__( 'Background Item', 'blackdsn' ) )
		        ->setLabelBlock()
		        ->setDefault( 'background-transparent' )
		        ->setSeparator( "after" )
		        ->get();

		$control->addPaddingGroup( 'item_padding_award_style', '.facts-item' )
		        ->get();


		$control->addBorder( 'item_award_border_style', '.facts-item' )
		        ->getGroup();

		$control->addBoxShadow( 'item_box_shadow', '.facts-item' )->get();


		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {


		$control = new blackdsnShortCode( array( 'widget-base' => $this ) );

		$items_key = $this->getKeys( 'items', [ 'title' => "none" ] );

		$this->addPrefixClassLayout( 'dsn-skills', $control );
		$this->addAnimateFade( 'dsn-skills-item', $control );
		$this->add_render_attribute( 'dsn-skills', 'class', 'dsn-skills' );


		echo '<div ' . $this->get_render_attribute_string( 'dsn-skills' ) . '>';
		echo blackdsn_shortcode_render_group( 'skills', array( 'widget-base' => $this ), $items_key );
		echo '</div>';


	}


}
