<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnMoveImage extends \Dsn\Element\BlackdsnLayout {

	use \Dsn\Element\Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_move_image';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Move Section Image', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-gallery-justified';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'image', 'photo', 'gallery', 'justified', 'slider' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();


		$this->remove_control( 'caption_source' );
		$control->addHidden( 'dsn_over_hidden' )
		        ->setDefault( 'over-hidden' )
		        ->setPrefix_class()
		        ->get();

		$control->getGroupGallery();


		$control->addChoose( 'position_move' )
		        ->setLabel( __( 'Position', 'blackdsn' ) )
		        ->setOptionChoose( 'move-left', esc_html__( 'Left', 'blackdsn' ), 'eicon-h-align-left' )
		        ->setOptionChoose( '', esc_html__( 'Right', 'blackdsn' ), 'eicon-h-align-right' )
		        ->setSeparatorBefore()
		        ->setDefault( '' )
		        ->get();


		$this->end_controls_section();
		$this->styleSettings();
		$this->getScroll();

	}

	private function getScroll() {
		$control = $this->getControl();
		$this->start_controls_section(
			'scroll_section',
			[
				'label' => esc_html__( 'Motion Effect', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			]
		);


		$control->addNumberSlider( 'speed_scroll', 0, 10, 0.1 )
		        ->setLabel( esc_html__( 'Speed Scroll', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'smooth scrubbing', 'blackdsn' ) )
		        ->setDefaultDesktopRange( 0.1 )
		        ->get();


		$control->addSwitcher( 'pin_scroll' )
		        ->setLabel( esc_html__( 'Pin', 'blackdsn' ) )
		        ->setDescription( esc_html__( 'pin the trigger element while active', 'blackdsn' ) )
		        ->get();

		$control->addText( 'start_scroll' )
		        ->setLabel( esc_html__( 'Offset Top Scroll', 'blackdsn' ) )
		        ->setDefault( "100%" )
		        ->get();

		$control->addText( 'end_scroll' )
		        ->setLabel( esc_html__( 'Offset Bottom Scroll', 'blackdsn' ) )
		        ->setDefault( "0%" )
		        ->get();


		$this->end_controls_section();

	}


	private function styleSettings() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Additional Options', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			]
		);

		$control->addNumberSlider( 'number_blackdsn', 1, 9, 1 )
		        ->setLabel( esc_html__( "Columns", 'blackdsn' ) )
		        ->setDefaultRange( 1 )
		        ->setSelectors( $this->style_layout, '--dsn-width-item: {{SIZE}};' )
		        ->getResponsive();

		$this->getGridSpace();

		$control->addSlider( 'height', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height', 'elementor' ) )
		        ->setSelectors( '.grid-item img', 'height: {{SIZE}}{{UNIT}};max-height: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();


		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$control = $this->getShortCode();
		$this->addPrefixClassLayout( 'dsn-gallery', $control );
		echo blackdsn_shortcode_render_group( 'move-section-image', array( 'widget-base' => $this ) );

	}


}
