<?php

use Dsn\Element\Blackdsn_Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnJustifyGallery extends Widget_Base {

	use Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_gallery';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Gallery Justified', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-gallery-justified';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'image', 'photo', 'gallery', 'justified', 'slider' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();

		$control->getGroupGallery();


		$this->add_control(
			'popup_image',
			[
				'label'     => __( 'Popup Image', 'blackdsn' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$control->addImageSize( 'size_img_popup' )
		        ->setDefault( 'full' )
		        ->getGroup();

		$control->addText( 'group_popup' )
		        ->setLabel( esc_html__( 'Group Gallery', 'blackdsn' ) )
		        ->get();


		$this->end_controls_section();

		$this->styleSettings();

	}


	private function styleSettings() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Additional Options', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$control->addNumberSlider( 'rowHeight', 0, 1000, 10 )
		        ->setLabel( __( 'Row Height', 'blackdsn' ) )
		        ->setDescription( __( 'The preferred rows height in pixel.', 'blackdsn' ) )
		        ->setDefaultRange( 320 )
		        ->get();

		$control->addNumberSlider( 'gutter', 0, 1000, 10 )
		        ->setLabel( __( 'Margins', 'blackdsn' ) )
		        ->setDescription( __( 'Decide the margins between the images.', 'blackdsn' ) )
		        ->setDefaultRange( 15 )
		        ->get();

		$control->addSelect( 'lastRow', [
			'left'   => __( 'Left', 'blackdsn' ),
			'center' => __( 'Center', 'blackdsn' ),
			'right'  => __( 'Right', 'blackdsn' ),
			'hide'   => __( 'Hide', 'blackdsn' ),
		] )
		        ->setLabel( __( 'Last row', 'blackdsn' ) )
		        ->setDefault( 'left' )
		        ->get();


		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		echo blackdsn_shortcode_render_group( 'justified-gallery', array( 'widget-base' => $this ) );
	}

	public function get_script_depends() {
		return $this->getDepends();
	}

	public function get_style_depends() {
		return $this->getDepends();
	}

	private function getDepends() {
		return [ blackdsnFrontEnd::FANCYBOX, blackdsnFrontEnd::FJ_Gallery ];
	}

}
