<?php

use Dsn\Element\Blackdsn_Widget_Base;
use Dsn\Element\BlackdsnLayout;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnInfoHeader extends BlackdsnLayout {

	use Blackdsn_Widget_Base;

	protected $range_col = 30;
	protected $range_row = 30;
	protected $default_mobile = false;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name(): string {
		return 'dsn_info_header';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title(): string {
		return __( 'Information Header', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon(): string {
		return 'eicon-info-circle-o';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords(): array {
		return array_merge( $this->dsn_keywords(), [ 'information', 'header' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();
		$this->getLayout();
		$control->getAlign()
		        ->getResponsive();

		$control->addSwitcher( 'list_with_number' )
		        ->setLabel( esc_html__( "List With Number", 'blackdsn' ) )
		        ->setReturn_value( 'list-with-number' )
		        ->setDescription( esc_html__( "if Us this feature can't us icon with list" ) )
		        ->setPrefix_class()
		        ->get();

		$control->startRepeater();

		$control->addText( 'title' )
		        ->setLabel( esc_html__( 'Title', 'blackdsn' ), true, false )
		        ->get();

		$control->addTextarea( 'content' )
		        ->setLabel( esc_html__( 'Content', 'blackdsn' ), true )
		        ->get();


		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( 'Items', 'blackdsn' ) )
		        ->setTitle_field( 'title' )
		        ->setDefault( blackdsn_default_info_header() )
		        ->get();

		$control->addSize()
		        ->setDefault( 'sm-title-block' )
		        ->setSeparatorBefore()
		        ->get();

		$this->end_controls_section();

		$this->option();
		$this->styleTitle();

	}


	private function option() {
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->getGridSpace();

		$this->end_controls_section();
	}


	private function styleTitle() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_title_section',
			[
				'label' => esc_html__( 'Style Title', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$control->addColor( 'color_content_title' )
		        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
		        ->setSelectors( 'h5', 'color:{{VALUE}};' )
		        ->get();
		$control->addTypography( 'title_typography', 'h5' )->getGroup();
		$control->addTextShadow( 'text_content_shadow_title', 'h5' )
		        ->getGroup();


		$this->end_controls_section();


		$this->start_controls_section(
			'style_content_section',
			[
				'label' => esc_html__( 'Style Content', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$control->addColor( 'color_content_span' )
		        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
		        ->setSelectors( 'p', 'color:{{VALUE}};' )
		        ->get();
		$control->addSlider( 'space', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Max Width', 'elementor' ) )
		        ->setSelectors( 'p', 'max-width: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->addTypography( 'span_typography', 'p' )->getGroup();
		$control->addTextShadow( 'text_content_shadow_span', 'p' )
		        ->getGroup();
		$this->end_controls_section();

	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$items_key = $this->getKeys( 'items', [ 'title', 'content' => 'none' ] );
		echo blackdsn_shortcode_render_group( 'info_header', array( 'widget-base' => $this ), $items_key );

	}


}
