<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnExperience extends \Elementor\Widget_Base {

	use \Dsn\Element\Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_experience';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Blackdsn Experience', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-person';

	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'experience', 'Education', 'Workshops' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function _register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Accordion', 'blackdsn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();


		$control->startRepeater();


		$control->addText( 'title' )
		        ->setDefault( 'Rolling Thunder' )
		        ->setLabel( esc_html__( "Title", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->get();

		$control->addText( 'position' )
		        ->setDefault( 'Senior UX / UI Designer' )
		        ->setLabel( esc_html__( "Position", 'blackdsn' ) )
		        ->setDynamicActive( true )
		        ->get();

		$control->addTextareaEditor( 'description' )
		        ->setLabel( esc_html__( "Description", 'blackdsn' ) )
		        ->setDefault( '<p>Praesent dignissim sollicitudin justo, sed elementum quam lacinia quis. Phasellus eleifend tristique posuere. Sed vitae dui nec magna.</p>' )
		        ->setTitle_field( 'title' )
		        ->setDynamicActive( true )
		        ->get();

		$control->endRepeater( 'items' )
		        ->setLabel( esc_html__( 'Items', 'blackdsn' ) )
		        ->setTitle_field( 'title' )
		        ->get();


		$this->end_controls_section();

		$this->styleTab();

	}


	private function styleTab() {
		$control = $this->getControl();


		$args = array(
			'resume-title'       => esc_html__( 'Title', 'blackdsn' ),
			'resume-position'    => esc_html__( 'Position', 'blackdsn' ),
			'resume-description' => esc_html__( 'Description', 'blackdsn' ),
		);

		foreach ( $args as $id => $value ):

			$this->start_controls_section(
				'style_content_service_' . $id,
				[
					'label' => $value,
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);


			$control->addColor( 'color_content_' . $id )
			        ->setLabel( esc_html__( "Color", 'blackdsn' ) )
			        ->setSeparator( "before" )
			        ->setSelectors( '.' . $id, 'color:{{VALUE}};' )
			        ->get();

			$control->addSlider( 'max-width-' . $id, $control->getDefaultWidthHeight() )
			        ->setLabel( __( 'Max Width', 'elementor' ) )
			        ->setSelectors( '.' . $id, 'max-width: {{SIZE}}{{UNIT}};' )
			        ->getResponsive();

			$control->addTypography( 'item_typo_content_' . $id, '.' . $id )
			        ->getGroup();


			$control->addTextShadow( 'text_content_shadow_' . $id, '.' . $id )
			        ->getGroup();

			$this->end_controls_section();


		endforeach;


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$items_key = $this->getKeys( 'items', [ 'title', 'position', 'description' => 'advanced' ] );
		echo blackdsn_shortcode_render_group( 'experience', array( 'widget-base' => $this ), $items_key );

	}


}
