<?php

use Dsn\Element\Blackdsn_Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnCompare extends Widget_Base {

	use Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_compare';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Compare Two Images', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-slider-full-screen';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'compare tow image', 'image' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Image Before', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->getImageOption();

		$this->end_controls_section();


		$this->start_controls_section(
			'content_section_after',
			[
				'label' => esc_html__( 'Image After', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->getImageOption( "after" );

		$this->end_controls_section();


		$this->styleTab();

	}


	private function getImageOption( $target = "before" ) {
		$control = $this->getControl();
		$control->getGroupImage( 'image_' . $target );
		$this->remove_control( 'caption_source' );
		$this->remove_control( 'caption' );
		$this->getOverlay( $target );
		$control->addBlendMode( 'bland_overlay' . $target, '.img-comp-' . $target . ' img' )->get();
		$control->addPopover( 'position_image' . $target )
		        ->setLabel( __( 'Position Image', 'blackdsn' ) )
		        ->get();

		$this->start_popover();
		$control->addNumber( 'position_image_position_x' . $target, 0, 100, 10 )
		        ->setLabel( __( 'Position X', 'blackdsn' ) )
		        ->setDefault( 50 )
		        ->get();


		$control->addNumber( 'position_image_position_y' . $target, 0, 100, 10 )
		        ->setLabel( __( 'Position Y', 'blackdsn' ) )
		        ->setDefault( 50 )
		        ->get();

		$this->end_popover();
		$this->add_control(
			'view' . $target,
			[
				'label'   => __( 'View', 'elementor' ),
				'type'    => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);
	}


	private function getOverlay( $target = 'before' ) {
		$control = $this->getControl();

		$control->addPopover( 'opacity_overlay_popover_' . $target )
		        ->setLabel( __( "Background Overlay", 'elementor' ) )
		        ->setSeparator( "before" )
		        ->get();

		$this->start_popover();

		$control->addColor( 'color_overlay_' . $target )
		        ->setLabel( __( 'Color Overlay' ) )
		        ->get();

		$control->addNumberSlider( 'opacity_overlay_' . $target, 0, 10, 1 )
		        ->setLabel( __( 'Opacity Overlay' ) )
		        ->setDefaultRange( 0 )
		        ->get();

		$this->end_popover();

	}


	private function styleTab() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_image_section',
			[
				'label' => __( 'Image', 'elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$control->addSlider( 'width', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Width', 'elementor' ) )
		        ->setSelectors( '.dsn-comp-container', 'width: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->addSlider( 'space', $control->getDefaultWidthHeight() )
		        ->setLabel( __( 'Max Width', 'elementor' ) )
		        ->setSelectors( '.dsn-comp-container', 'max-width: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->addSlider( 'height', $control->getDefaultWidthHeight( 'vh' ) )
		        ->setLabel( __( 'Height', 'elementor' ) )
		        ->setSelectors( '.dsn-comp-container', 'height: {{SIZE}}{{UNIT}};' )
		        ->getResponsive();

		$control->getAlign()->getResponsive();


		$control->addSelect( 'object-fit', [
			''        => __( 'Default', 'elementor' ),
			'fill'    => __( 'Fill', 'elementor' ),
			'cover'   => __( 'Cover', 'elementor' ),
			'contain' => __( 'Contain', 'elementor' ),
		], [
			'label' => __( 'Object Fit', 'elementor' ),

			'options'   => [
				''        => __( 'Default', 'elementor' ),
				'fill'    => __( 'Fill', 'elementor' ),
				'cover'   => __( 'Cover', 'elementor' ),
				'contain' => __( 'Contain', 'elementor' ),
			],
			'default'   => '',
			'selectors' => [
				'{{WRAPPER}} img' => 'object-fit: {{VALUE}};',
			],
		] )->setSeparator( "before" )->get();


		$this->end_controls_section();


	}


	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		echo blackdsn_shortcode_render_group( 'compare', array( 'widget-base' => $this ) );
	}


}
