<?php

use Dsn\Element\Blackdsn_Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Elementor accordion widget.
 *
 * Elementor widget that displays a collapsible display of content in an
 * accordion style, showing only one item at a time.
 *
 * @since 1.0.0
 */
class BlackdsnBGMask extends Widget_Base {

	use Blackdsn_Widget_Base;


	/**
	 * Get widget name.
	 *
	 * Retrieve accordion widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'dsn_bg_mask';
	}


	/**
	 * Get widget title.
	 *
	 * Retrieve accordion widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return __( 'Background Mask', 'blackdsn' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve accordion widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'eicon-background';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 * @since 2.1.0
	 * @access public
	 *
	 */
	public function get_keywords() {
		return array_merge( $this->dsn_keywords(), [ 'mask', 'background' ] );
	}


	/**
	 * Register accordion widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Background Mask', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);


		$control = $this->getControl();


		$control->addHidden( 'bg_mask_hidden' )
		        ->setDefault( 'dsn-equal-height h-100' )
		        ->setPrefix_class()
		        ->get();


		$control->addSelect( 'background_ver_mask', $control->getOptionVerBackground() )
		        ->setLabel( esc_html__( 'Version Background', 'blackdsn' ) )
		        ->setDefault( '' )
		        ->get();

		$control->addSelect( 'background_mask', $control->getOptionBackground() )
		        ->setLabel( esc_html__( 'Background Mask', 'blackdsn' ) )
		        ->setDefault( 'background-section' )
		        ->get();


		$default_width = [
			'size_units' => [ '%', 'px', 'vw' ],
			'range'      => [
				'%'  => [
					'min' => - 100,
					'max' => 100,
				],
				'px' => [
					'min' => - 1000,
					'max' => 1000,
				],
				'vw' => [
					'min' => - 100,
					'max' => 100,
				],
			],
		];

		$default_height = [
			'size_units' => [ '%', 'px', 'vh' ],
			'range'      => [
				'%'  => [
					'min' => - 100,
					'max' => 100,
				],
				'px' => [
					'min' => - 1000,
					'max' => 1000,
				],
				'vh' => [
					'min' => - 100,
					'max' => 100,
				],
			],
		];

		$key = '.dsn-bg-mask';

		$control->addSlider( 'width_mask', $default_width )
		        ->setLabel( esc_html__( 'Width Mask', 'blackdsn' ) )
		        ->setSelectors( $key, '--width-mask:{{SIZE}}{{UNIT}}' )
		        ->setSeparator( "before" )
		        ->getResponsive();

		$control->addSlider( 'calc_width_mask', $default_width )
		        ->setLabel( esc_html__( 'Plus Width Mask', 'blackdsn' ) )
		        ->setSelectors( $key, '--width-calc-mask:{{SIZE}}{{UNIT}}' )
		        ->getResponsive();

		$control->addSlider( 'height_mask', $default_height )
		        ->setLabel( esc_html__( 'Height Mask', 'blackdsn' ) )
		        ->setSelectors( $key, '--height-mask:{{SIZE}}{{UNIT}}' )
		        ->setSeparator( "before" )
		        ->getResponsive();


		$control->addSlider( 'calc_height_mask', $default_height )
		        ->setLabel( esc_html__( 'Plus Height Mask', 'blackdsn' ) )
		        ->setSelectors( $key, '--height-calc-mask:{{SIZE}}{{UNIT}}' )
		        ->getResponsive();


		$control->addSlider( 'top_mask', $default_height )
		        ->setLabel( esc_html__( 'Top', 'blackdsn' ) )
		        ->setSelectors( $key, '--top-mask:{{SIZE}}{{UNIT}}' )
		        ->setSeparator( "before" )
		        ->getResponsive();

		$control->addSlider( 'left_mask', $default_width )
		        ->setLabel( esc_html__( 'Left', 'blackdsn' ) )
		        ->setSelectors( $key, '--left-mask:{{SIZE}}{{UNIT}}' )
		        ->getResponsive();

		$control->addSlider( 'margin_top_mask', $default_height )
		        ->setLabel( esc_html__( 'Margin Top', 'blackdsn' ) )
		        ->setSeparator( "before" )
		        ->setSelectors( $key, '--margin-top-mask:{{SIZE}}{{UNIT}}' )
		        ->getResponsive();

		$control->addSlider( 'margin_left_mask', $default_width )
		        ->setLabel( esc_html__( 'Margin Left', 'blackdsn' ) )
		        ->setSelectors( $key, '--margin-left-mask:{{SIZE}}{{UNIT}}' )
		        ->getResponsive();


		$this->end_controls_section();

		$this->styleTab();

	}


	private function styleTab() {
		$control = $this->getControl();

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'blackdsn' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'background',
				'label'    => esc_html__( 'Background', 'blackdsn' ),
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .dsn-bg-mask',
			]
		);

		$this->add_responsive_control(
			'opacity',
			[
				'label'     => __( 'Opacity', 'elementor' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .dsn-bg-mask ' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label'      => __( 'Border Radius', 'elementor' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'separator'  => 'before',
				'selectors'  => [
					'{{WRAPPER}} .dsn-bg-mask  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$control->addBorder( 'item_border_mask','.dsn-bg-mask' )->getGroup();


		$this->end_controls_section();


	}

	/**
	 * Render accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		echo blackdsn_shortcode_render_group( 'bg-mask', array( 'widget-base' => $this ) );

	}

	protected function content_template() {
		echo blackdsn_shortcode_js_group( 'bg-mask', array( 'widget-base' => $this ) );
	}


}
