<?php

trait notices {


	/**
	 *
	 * Admin notice
	 *
	 * @return bool
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function elementorLoaded(): bool {


		if ( did_action( 'elementor/loaded' ) ) {
			// Check for required Elementor version
			if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
				add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );

				return false;
			}
		}

		return true;
	}


	/**
	 *
	 * Admin notice
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @return bool
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function PHPVer(): bool {


		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MIN_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_min_php_version' ] );

			return false;
		}


		return true;
	}


	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
		/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'elementor-test-extension' ),
			'<strong>' . esc_html__( 'Elementor Test Extension', 'arctit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'arctit' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}


	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function admin_notice_min_php_version() {

		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		printf( '<div class="notice notice-error is-dismissible"><p>%1$s</p><p>%2$s</p></div>', sprintf(
		/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'arctit' ),
			'<strong>' . esc_html__( 'Droow Widget Extension', 'arctit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'arctit' ) . '</strong>',
			self::MIN_PHP_VERSION
		),
			esc_html__( "these older versions have reached official End Of Life and as such may expose your site to security vulnerabilities and bugs, and may not always work as expected.", 'arctit' ) );

	}

}