<?php

use Elementor\Controls_Manager;
use Elementor\Core\DocumentTypes\PageBase;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Page Header in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'blackdsn_document_settings_page_title' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'blackdsn_document_settings_page_title' );
function blackdsn_document_settings_page_title( PageBase $page ) {
	$control = new blackdsnControl( $page );

	$page->start_controls_section(
		'page_title_section',
		array(
			'label'     => esc_html__( 'Title Area', 'blackdsn' ),
			'tab'       => Controls_Manager::TAB_SETTINGS,
			'condition' => [ 'show_header' => '1' ]
		)
	);

	$control->addSelect( 'text_layout', [
		'dsn-container' => esc_html__( "Wide Page", "blackdsn" ),
		'container'     => esc_html__( "Container Page", "blackdsn" ),
	] )
	        ->setDefault( 'container' )
	        ->setLabel( esc_html__( "Text Layout", "blackdsn" ) )
	        ->get();


	$control->addTextarea( 'custom_title' )
	        ->setLabelBlock()
	        ->setLabel( esc_html__( 'Custom Title', 'blackdsn' ) )
	        ->get();


	if ( blackdsn_is_work() ) {
		$control->addText( 'year_project' )
		        ->setLabel( esc_html__( 'Year', 'blackdsn' ) )
		        ->get();

		$control->addLink( 'head_link' )
		        ->setLabelBlock()
		        ->setLabel( esc_html__( 'Link', 'blackdsn' ) )
		        ->get();

		$control->addText( 'text_link' )
		        ->setLabel( esc_html__( 'Text Link', 'blackdsn' ) )
		        ->setDefault( esc_html__( 'VISIT SITE', 'blackdsn' ) )
		        ->setConditions( 'head_link[url]', '!=', '' )
		        ->get();
	}

	$control->addTextarea( 'subtitle' )
	        ->setLabel( esc_html__( 'SubTitle', 'blackdsn' ) )
	        ->setSeparatorAfter()
	        ->get();


	$control->addTypography( 'title_typography', '#hero_title .title' )
	        ->getGroup();

	$control->getJustifyContent( 'justify_content_title_doc', '#dsn_header #hero_content' )
	        ->setDefault( 'start' )
	        ->getResponsive();

	$control->getAlignmentItem( 'alignment_item_title_doc', '#dsn_header #hero_content' )
	        ->setDefault( 'end' )
	        ->getResponsive();

	$control->getAlign( 'alignment_title_doc' )
	        ->setDefault( 'left' )
	        ->setPrefix_class( false )
	        ->setSelectors( '#dsn_header #hero_content', 'text-align: {{VALUE}};' )
	        ->getResponsive();

	$page->end_controls_section();
}