<?php

use Elementor\Controls_Manager;
use Elementor\Core\DocumentTypes\PageBase;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


/**
 * Page Header in Elementor Document Settings
 */
add_action('elementor/element/wp-page/document_settings/after_section_end', 'blackdsn_document_settings_page_layout');
add_action('elementor/element/wp-post/document_settings/after_section_end', 'blackdsn_document_settings_page_layout');
function blackdsn_document_settings_page_layout(PageBase $page)
{

    $control = new blackdsnControl($page);

    $page->start_controls_section(
        'page_layout_section',
        array(
            'label' => esc_html__('Layout', 'blackdsn'),
            'tab' => Controls_Manager::TAB_SETTINGS,
        )
    );

    $control->addSelect('page_layout', [
        '' => esc_html__("Full Width", "blackdsn"),
        'container' => esc_html__("Container", "blackdsn"),
        'dsn-container' => esc_html__("Container Fluid", "blackdsn"),
    ])
        ->setDefault(blackdsn_is_work() ? '' : 'container')
        ->setLabel(esc_html__("Page Layout", "blackdsn"))
        ->get();


    $control->addSelect('global_background_color', [
        "auto" => esc_html__("Auto", "blackdsn"),
        'v-dark' => esc_html__("Dark", "blackdsn"),
        'v-light' => esc_html__("Light", "blackdsn"),
    ])
        ->setDefault("auto")
        ->setLabel(esc_html__("Background Color", "blackdsn"))
        ->get();


    $control->addSwitcher('show_cart')
        ->setLabel(esc_attr__('Show Cart', 'blackdsn'))
        ->setLabel_on(esc_attr__('Show', 'blackdsn'))
        ->setLabel_off(esc_attr__('Hide', 'blackdsn'))
        ->get();

    $control->addSwitcher('show_sidebar')
        ->setReturn_value('show')
        ->setLabel(esc_attr__('Show Sidebar', 'blackdsn'))
        ->setLabel_on(esc_attr__('Show', 'blackdsn'))
        ->setLabel_off(esc_attr__('Hide', 'blackdsn'))
        ->setDefault('show')
        ->get();

    $control->addSelect('choose_sidebar', [
        "blog-sidebar-1" => esc_html__("Blog Sidebar", "blackdsn"),
        'wc-sidebar-1' => esc_html__("Woocommerce Sidebar", "blackdsn")
    ])
        ->setDefault("auto")
        ->setLabel(esc_html__("Choose Sidebar", "blackdsn"))
        ->setConditions('show_sidebar', 'show')
        ->setDefault('blog-sidebar-1')
        ->get();

    $page->end_controls_section();

}