<?php

use Elementor\Controls_Manager;
use Elementor\Core\DocumentTypes\PageBase;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Page Header in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'blackdsn_document_settings_page_header' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'blackdsn_document_settings_page_header' );
function blackdsn_document_settings_page_header( PageBase $page ) {

	$control = new blackdsnControl( $page );

	$page->start_controls_section(
		'page_header_section',
		array(
			'label' => esc_html__( 'Page Header', 'blackdsn' ),
			'tab'   => Controls_Manager::TAB_SETTINGS,
		)
	);

	$control->addSwitcher( 'show_menu' )
	        ->setLabel( esc_html__( 'Show Menu', 'blackdsn' ) )
	        ->setDefault( '1' )
	        ->get();


	$control->addSelect( 'menu_type', [
		'auto'          => esc_html__( "Auto", "blackdsn" ),
		''              => esc_html__( "Classic", "blackdsn" ),
		'dsn-hamburger' => esc_html__( "Hamburger", "blackdsn" )
	] )
	        ->setDefault( "auto" )
	        ->setLabel( esc_html__( "Menu Type", "blackdsn" ) )
	        ->setConditions( 'show_menu', '1' )
	        ->get();

	$menus           = wp_get_nav_menus();
	$option_menus    = [];
	$option_menus[0] = esc_html__( 'Default Menu', 'blackdsn' );
	foreach ( $menus as $menu ) {
		$option_menus[ $menu->slug ] = $menu->name;
	}
	$control->addSelect( 'menu_id', $option_menus )
	        ->setDefault( 0 )
	        ->setLabel( esc_html__( "Menu", "blackdsn" ) )
	        ->setConditions( 'show_menu', '1' )
	        ->get();


	$control->addSwitcher( 'show_header' )
	        ->setLabel( esc_html__( 'Show Header', 'blackdsn' ) )
	        ->setDefault( '1' )
	        ->setSeparatorBefore()
	        ->get();

	$control->addSelect( 'image_type', [
		'dsn-full-header' => esc_html__( "Full Width", "blackdsn" ),
		''                => esc_html__( "Padding", "blackdsn" ),
		'header-padding'  => esc_html__( "Default length", "blackdsn" ),
		'left-img'        => esc_html__( "Left Image", "blackdsn" ),
		'right-img'       => esc_html__( "Right Image", "blackdsn" ),
	] )
	        ->setDefault( '' )
	        ->setLabel( esc_html__( "Image Type", "blackdsn" ) )
	        ->setConditions( 'show_header', '1' )
	        ->get();


	$control->addSwitcher( 'show_box_shadow' )
	        ->setLabel( esc_html__( "Show Box Shadow", "blackdsn" ) )
	        ->setConditions( 'show_header', '1' )
	        ->setDefault( 'show-box-shadow' )
	        ->setReturn_value( 'show-box-shadow' )
	        ->get();


	$control->addImageSize()
	        ->setDefault( '' )
	        ->setDefault( 'full' )
	        ->setConditions( 'show_header', '1' )
	        ->get();

	$control->addSwitcher( 'show_background_video' )
	        ->setLabel( esc_html__( 'Feature Video', 'blackdsn' ) )
	        ->setConditions( 'show_header', '1' )
	        ->get();

	$control->addText( 'dsn_video_link' )
	        ->setLabel( esc_html__( 'Video Link', 'blackdsn' ) )
	        ->setLabelBlock()
	        ->setCondition( [
		        'show_background_video' => '1',
		        'show_header'           => '1',
	        ] )
	        ->get();


	$control->addNumberSlider( 'opacity_overlay', 1, 10, 1 )
	        ->setLabel( esc_html__( 'Opacity Overlay', 'blackdsn' ) )
	        ->setDefaultRange( 4 )
	        ->setConditions( 'show_header', '1' )
	        ->get();

	$control->addNumberSlider( 'background_option_position_image_position_x', 0, 100, 1 )
	        ->setLabel( esc_html__( 'Image Position X', 'blackdsn' ) )
	        ->setDefaultRange( 50 )
	        ->setConditions( 'show_header', '1' )
	        ->setSelectors( '#dsn_header #hero_image .transform-3d',
		        'object-position:{{SIZE}}% {{background_option_position_image_position_y.SIZE}}%' )
	        ->getResponsive();

	$control->addNumberSlider( 'background_option_position_image_position_y', 0, 100, 1 )
	        ->setLabel( esc_html__( 'Image Position Y', 'blackdsn' ) )
	        ->setDefaultRange( 50 )
	        ->setConditions( 'show_header', '1' )
	        ->setSelectors( '#dsn_header #hero_image .transform-3d',
		        'object-position:{{background_option_position_image_position_x.SIZE}}% {{SIZE}}%' )
	        ->getResponsive();


	$page->end_controls_section();

}